/*
 * Decompiled with CFR 0.152.
 */
package fuzs.deathcompass.client.renderer.item;

import fuzs.deathcompass.world.item.DeathCompassItem;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DeathCompassPropertyFunction
implements ClampedItemPropertyFunction {
    private final CompassWobble wobble = new CompassWobble();
    private final CompassWobble wobbleRandom = new CompassWobble();

    public float m_142187_(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity livingEntity, int p_174675_) {
        LivingEntity entity;
        Object object = entity = livingEntity != null ? livingEntity : stack.m_41609_();
        if (entity == null || !stack.m_41782_()) {
            return 0.0f;
        }
        if (level == null && entity.f_19853_ instanceof ClientLevel) {
            level = (ClientLevel)entity.f_19853_;
        }
        BlockPos blockpos = this.getLastDeathPosition((Level)level, stack.m_41784_());
        long gameTime = level.m_46467_();
        if (blockpos != null && !(entity.m_20182_().m_82531_((double)blockpos.m_123341_() + 0.5, entity.m_20182_().m_7098_(), (double)blockpos.m_123343_() + 0.5) < (double)1.0E-5f)) {
            double d3;
            boolean flag = livingEntity instanceof Player && ((Player)livingEntity).m_7578_();
            double d1 = 0.0;
            if (flag) {
                d1 = livingEntity.m_146908_();
            } else if (entity instanceof ItemFrame) {
                d1 = this.getFrameRotation((ItemFrame)entity);
            } else if (entity instanceof ItemEntity) {
                d1 = 180.0f - ((ItemEntity)entity).m_32008_(0.5f) / ((float)Math.PI * 2) * 360.0f;
            } else if (livingEntity != null) {
                d1 = livingEntity.f_20883_;
            }
            d1 = Mth.m_14109_((double)(d1 / 360.0), (double)1.0);
            double d2 = this.getAngleTo(Vec3.m_82512_((Vec3i)blockpos), (Entity)entity) / 6.2831854820251465;
            if (flag) {
                if (this.wobble.shouldUpdate(gameTime)) {
                    this.wobble.update(gameTime, 0.5 - (d1 - 0.25));
                }
                d3 = d2 + this.wobble.rotation;
            } else {
                d3 = 0.5 - (d1 - 0.25 - d2);
            }
            return Mth.m_14091_((float)((float)d3), (float)1.0f);
        }
        if (this.wobbleRandom.shouldUpdate(gameTime)) {
            this.wobbleRandom.update(gameTime, Math.random());
        }
        double d0 = this.wobbleRandom.rotation + (double)((float)this.hash(p_174675_) / 2.1474836E9f);
        return Mth.m_14091_((float)((float)d0), (float)1.0f);
    }

    private int hash(int p_174670_) {
        return p_174670_ * 1327217883;
    }

    @Nullable
    private BlockPos getLastDeathPosition(Level p_117916_, CompoundTag p_117917_) {
        Optional<ResourceKey<Level>> optional;
        boolean flag = p_117917_.m_128441_("LastDeathPos");
        boolean flag1 = p_117917_.m_128441_("LastDeathDimension");
        if (flag && flag1 && (optional = DeathCompassItem.getLastDeathDimension(p_117917_)).isPresent() && p_117916_.m_46472_() == optional.get()) {
            return NbtUtils.m_129239_((CompoundTag)p_117917_.m_128469_("LastDeathPos"));
        }
        return null;
    }

    private double getFrameRotation(ItemFrame p_117914_) {
        Direction direction = p_117914_.m_6350_();
        int i = direction.m_122434_().m_122478_() ? 90 * direction.m_122421_().m_122540_() : 0;
        return Mth.m_14098_((int)(180 + direction.m_122416_() * 90 + p_117914_.m_31823_() * 45 + i));
    }

    private double getAngleTo(Vec3 p_117919_, Entity p_117920_) {
        return Math.atan2(p_117919_.m_7094_() - p_117920_.m_20189_(), p_117919_.m_7096_() - p_117920_.m_20185_());
    }

    private static class CompassWobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        private CompassWobble() {
        }

        public boolean shouldUpdate(long p_117934_) {
            return this.lastUpdateTick != p_117934_;
        }

        public void update(long p_117936_, double p_117937_) {
            this.lastUpdateTick = p_117936_;
            double d0 = p_117937_ - this.rotation;
            d0 = Mth.m_14109_((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += d0 * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.m_14109_((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }
}

