/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.client.generators.textures.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dark_roleplay.marg.client.generators.textures.generator.TextureGeneratorTask;
import net.dark_roleplay.marg.client.generators.textures.texture.TextureHolder;
import net.dark_roleplay.marg.client.generators.textures.util.TextureCache;
import net.dark_roleplay.marg.client.providers.ClientTextureProvider;
import net.dark_roleplay.marg.common.material.MargMaterial;
import net.dark_roleplay.marg.common.material.MaterialCondition;

public class TextureGenerator {
    private final int generatorVersion;
    private final MaterialCondition condition;
    private final Map<String, String> userInputs;
    private final List<TextureGeneratorTask> tasks;
    private final Map<String, TextureHolder> textures;
    public static final Codec<TextureGenerator> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.optionalFieldOf("generatorVersion", (Object)0).forGetter(TextureGenerator::getGeneratorVersion), (App)MaterialCondition.CODEC.fieldOf("material").forGetter(TextureGenerator::getCondition), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("requiredTextures").forGetter(TextureGenerator::getUserInputs), (App)TextureGeneratorTask.CODEC.listOf().fieldOf("tasks").forGetter(TextureGenerator::getTasks)).apply((Applicative)i, TextureGenerator::new));

    public TextureGenerator(Integer generatorVersion, MaterialCondition condition, Map<String, String> userInputs, List<TextureGeneratorTask> tasks) {
        this.generatorVersion = generatorVersion;
        this.condition = condition;
        this.userInputs = userInputs;
        this.tasks = tasks;
        this.textures = new HashMap<String, TextureHolder>();
    }

    public void generate(MargMaterial material) {
        ClientTextureProvider textProv = (ClientTextureProvider)material.getTextureProvider();
        TextureCache globalCache = TextureCache.getGlobalCacheFor(material);
        TextureCache localCache = new TextureCache(globalCache);
        for (TextureGeneratorTask task : this.tasks) {
            task.generate(material, textProv, this.textures, globalCache, localCache);
        }
    }

    public int getGeneratorVersion() {
        return this.generatorVersion;
    }

    public MaterialCondition getCondition() {
        return this.condition;
    }

    public Map<String, String> getUserInputs() {
        return this.userInputs;
    }

    public List<TextureGeneratorTask> getTasks() {
        return this.tasks;
    }

    public void addTexture(String key, TextureHolder texture) {
        this.textures.put(key, texture);
    }
}

