/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.vanilla.crafting;

import java.util.List;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.util.RecipeErrorUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CategoryRecipeValidator<T extends Recipe<?>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int INVALID_COUNT = -1;
    private final IRecipeCategory<T> recipeCategory;
    private final int maxInputs;

    public CategoryRecipeValidator(IRecipeCategory<T> recipeCategory, int maxInputs) {
        this.recipeCategory = recipeCategory;
        this.maxInputs = maxInputs;
    }

    public boolean isRecipeValid(T recipe) {
        return this.hasValidInputsAndOutputs(recipe);
    }

    public boolean isRecipeHandled(T recipe) {
        return this.recipeCategory.isHandled(recipe);
    }

    private boolean hasValidInputsAndOutputs(T recipe) {
        if (recipe.m_5598_()) {
            return true;
        }
        ItemStack recipeOutput = recipe.m_8043_();
        if (recipeOutput == null || recipeOutput.m_41619_()) {
            String recipeInfo = RecipeErrorUtil.getInfoFromRecipe(recipe, this.recipeCategory);
            LOGGER.error("Recipe has no output. {}", (Object)recipeInfo);
            return false;
        }
        NonNullList ingredients = recipe.m_7527_();
        if (ingredients == null) {
            String recipeInfo = RecipeErrorUtil.getInfoFromRecipe(recipe, this.recipeCategory);
            LOGGER.error("Recipe has no input Ingredients. {}", (Object)recipeInfo);
            return false;
        }
        int inputCount = CategoryRecipeValidator.getInputCount((List<Ingredient>)ingredients);
        if (inputCount == -1) {
            return false;
        }
        if (inputCount > this.maxInputs) {
            String recipeInfo = RecipeErrorUtil.getInfoFromRecipe(recipe, this.recipeCategory);
            LOGGER.error("Recipe has too many inputs. {}", (Object)recipeInfo);
            return false;
        }
        if (inputCount == 0 && this.maxInputs > 0) {
            String recipeInfo = RecipeErrorUtil.getInfoFromRecipe(recipe, this.recipeCategory);
            LOGGER.error("Recipe has no inputs. {}", (Object)recipeInfo);
            return false;
        }
        return true;
    }

    private static int getInputCount(List<Ingredient> ingredientList) {
        int inputCount = 0;
        for (Ingredient ingredient : ingredientList) {
            ItemStack[] input = ingredient.m_43908_();
            if (input == null) {
                return -1;
            }
            ++inputCount;
        }
        return inputCount;
    }
}

