/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.ChamTileEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerData;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemHandler;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntitySlave
extends ChamTileEntity
implements IDrawerGroup {
    private static final int[] drawerSlots = new int[]{0};
    public final ControllerData controllerData = new ControllerData();
    static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemHandler>(){});
    static Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemRepository>(){});
    static Capability<IDrawerGroup> DRAWER_GROUP_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDrawerGroup>(){});
    private final DrawerItemHandler itemHandler = new DrawerItemHandler(this);
    private final ItemRepositoryProxy itemRepository = new ItemRepositoryProxy();
    private final LazyOptional<?> capabilityItemHandler = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<?> capabilityItemRepository = LazyOptional.of(() -> this.itemRepository);
    private final LazyOptional<?> capabilityGroup = LazyOptional.of(() -> this);

    public TileEntitySlave(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
        this.injectData(this.controllerData);
    }

    public TileEntitySlave(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.CONTROLLER_SLAVE.get(), pos, state);
    }

    @Override
    public boolean isGroupValid() {
        return !this.m_58901_();
    }

    public void bindController(BlockPos coord) {
        if (this.controllerData.bindCoord(coord)) {
            this.m_6596_();
        }
    }

    public BlockPos getControllerPos() {
        return this.controllerData.getCoord();
    }

    public TileEntityController getController() {
        return this.controllerData.getController(this);
    }

    @Override
    @Nonnull
    public int[] getAccessibleDrawerSlots() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.m_58899_())) {
            return drawerSlots;
        }
        return controller.getAccessibleDrawerSlots();
    }

    @Override
    public int getDrawerCount() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.m_58899_())) {
            return 0;
        }
        return controller.getDrawerCount();
    }

    @Override
    @Nonnull
    public IDrawer getDrawer(int slot) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.m_58899_())) {
            return Drawers.DISABLED;
        }
        return controller.getDrawer(slot);
    }

    public void m_6596_() {
        TileEntityController controller = this.getController();
        if (controller != null && controller.isValidSlave(this.m_58899_())) {
            controller.m_6596_();
        }
        super.m_6596_();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ITEM_HANDLER_CAPABILITY) {
            return this.capabilityItemHandler.cast();
        }
        if (capability == ITEM_REPOSITORY_CAPABILITY) {
            return this.capabilityItemRepository.cast();
        }
        if (capability == DRAWER_GROUP_CAPABILITY) {
            return this.capabilityGroup.cast();
        }
        return super.getCapability(capability, facing);
    }

    private class ItemRepositoryProxy
    implements IItemRepository {
        private ItemRepositoryProxy() {
        }

        @Override
        @Nonnull
        public NonNullList<IItemRepository.ItemRecord> getAllItems() {
            TileEntityController controller = TileEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(TileEntitySlave.this.m_58899_())) {
                return NonNullList.m_122779_();
            }
            return controller.getItemRepository().getAllItems();
        }

        @Override
        @Nonnull
        public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate, Predicate<ItemStack> predicate) {
            TileEntityController controller = TileEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(TileEntitySlave.this.m_58899_())) {
                return stack;
            }
            return controller.getItemRepository().insertItem(stack, simulate, predicate);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(@Nonnull ItemStack stack, int amount, boolean simulate, Predicate<ItemStack> predicate) {
            TileEntityController controller = TileEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(TileEntitySlave.this.m_58899_())) {
                return ItemStack.f_41583_;
            }
            return controller.getItemRepository().extractItem(stack, amount, simulate, predicate);
        }

        @Override
        public int getStoredItemCount(@Nonnull ItemStack stack, Predicate<ItemStack> predicate) {
            TileEntityController controller = TileEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(TileEntitySlave.this.m_58899_())) {
                return 0;
            }
            return controller.getItemRepository().getStoredItemCount(stack, predicate);
        }

        @Override
        public int getRemainingItemCapacity(@Nonnull ItemStack stack, Predicate<ItemStack> predicate) {
            TileEntityController controller = TileEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(TileEntitySlave.this.m_58899_())) {
                return 0;
            }
            return controller.getItemRepository().getRemainingItemCapacity(stack, predicate);
        }

        @Override
        public int getItemCapacity(@Nonnull ItemStack stack, Predicate<ItemStack> predicate) {
            TileEntityController controller = TileEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(TileEntitySlave.this.m_58899_())) {
                return 0;
            }
            return controller.getItemRepository().getItemCapacity(stack, predicate);
        }
    }
}

