/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.workers;

import de.geheimagentnr1.world_pre_generator.elements.queues.PregenTaskQueue;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.PrinterSubTask;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.SaverSubTask;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.PregenTask;
import de.geheimagentnr1.world_pre_generator.helpers.DimensionHelper;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.WorldWorkerManager;

public class PregenWorker
implements WorldWorkerManager.IWorker {
    private static final PregenWorker INSTANCE = new PregenWorker();
    private MinecraftServer server;
    private final PregenTaskQueue queue = new PregenTaskQueue();
    private final PrinterSubTask printer = new PrinterSubTask(this.queue);
    private final SaverSubTask saver = new SaverSubTask(this.printer);
    private boolean startingNewTask = true;

    private PregenWorker() {
    }

    public static PregenWorker getInstance() {
        return INSTANCE;
    }

    public void setServer(MinecraftServer _server) {
        this.server = _server;
        this.queue.setServer(this.server);
        this.printer.setServer(this.server);
        this.saver.setServer(this.server);
    }

    public boolean hasWork() {
        return true;
    }

    public boolean doWork() {
        Optional<PregenTask> next_task = this.queue.getCurrentTask();
        if (next_task.isPresent()) {
            PregenTask task = next_task.get();
            if (this.startingNewTask) {
                this.startingNewTask = false;
                this.server.m_6846_().m_11264_((Component)new TextComponent(String.format("Generation of %s started.", DimensionHelper.getNameOfDim(task.getDimension()))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY))), ChatType.SYSTEM, Util.f_137441_);
                this.printer.start();
                this.saver.start();
            }
            boolean finished = task.generate(this.server);
            this.printer.run();
            this.saver.run();
            if (finished) {
                this.printer.stop();
                this.saver.stop();
                this.printer.execute();
                this.server.m_6846_().m_11264_((Component)new TextComponent(String.format("Generation of %s finished.", DimensionHelper.getNameOfDim(task.getDimension()))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY))), ChatType.SYSTEM, Util.f_137441_);
                this.saver.execute();
                this.queue.removeCurrentTask();
                this.startingNewTask = true;
                return this.queue.isNotEmpty();
            }
            return true;
        }
        return false;
    }

    public PregenTaskQueue getQueue() {
        return this.queue;
    }

    public void clearUp() {
        this.queue.clearUp();
        this.startingNewTask = true;
        this.printer.stop();
        this.saver.stop();
    }
}

