/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.shadowed.com.typesafe.config.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import snownee.kiwi.shadowed.com.typesafe.config.ConfigException;
import snownee.kiwi.shadowed.com.typesafe.config.impl.AbstractConfigNodeValue;
import snownee.kiwi.shadowed.com.typesafe.config.impl.AbstractConfigValue;
import snownee.kiwi.shadowed.com.typesafe.config.impl.ConfigReference;
import snownee.kiwi.shadowed.com.typesafe.config.impl.ConfigString;
import snownee.kiwi.shadowed.com.typesafe.config.impl.Path;
import snownee.kiwi.shadowed.com.typesafe.config.impl.PathParser;
import snownee.kiwi.shadowed.com.typesafe.config.impl.SubstitutionExpression;
import snownee.kiwi.shadowed.com.typesafe.config.impl.Token;
import snownee.kiwi.shadowed.com.typesafe.config.impl.Tokens;

final class ConfigNodeSimpleValue
extends AbstractConfigNodeValue {
    final Token token;

    ConfigNodeSimpleValue(Token value) {
        this.token = value;
    }

    @Override
    protected Collection<Token> tokens() {
        return Collections.singletonList(this.token);
    }

    protected Token token() {
        return this.token;
    }

    protected AbstractConfigValue value() {
        if (Tokens.isValue(this.token)) {
            return Tokens.getValue(this.token);
        }
        if (Tokens.isUnquotedText(this.token)) {
            return new ConfigString.Unquoted(this.token.origin(), Tokens.getUnquotedText(this.token));
        }
        if (Tokens.isSubstitution(this.token)) {
            List<Token> expression = Tokens.getSubstitutionPathExpression(this.token);
            Path path = PathParser.parsePathExpression(expression.iterator(), this.token.origin());
            boolean optional = Tokens.getSubstitutionOptional(this.token);
            return new ConfigReference(this.token.origin(), new SubstitutionExpression(path, optional));
        }
        throw new ConfigException.BugOrBroken("ConfigNodeSimpleValue did not contain a valid value token");
    }
}

