/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.EnumMap;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.AbstractKeypadFurnaceBlock;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.network.client.RefreshDisguisableModel;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;

public abstract class AbstractKeypadFurnaceBlockEntity
extends AbstractFurnaceBlockEntity
implements IPasswordProtected,
MenuProvider,
IOwnable,
INameSetter,
IModuleInventory,
ICustomizable,
ILockable {
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private Owner owner = new Owner();
    private String passcode;
    private NonNullList<ItemStack> modules = NonNullList.m_122780_((int)this.getMaxNumberOfModules(), (Object)ItemStack.f_41583_);
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private EnumMap<ModuleType, Boolean> moduleStates = new EnumMap(ModuleType.class);

    public AbstractKeypadFurnaceBlockEntity(BlockEntityType<?> beType, BlockPos pos, BlockState state, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        super(beType, pos, state, recipeType);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeModuleInventory(tag);
        this.writeModuleStates(tag);
        this.writeOptions(tag);
        if (this.owner != null) {
            this.owner.save(tag, false);
        }
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.m_128359_("passcode", this.passcode);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.modules = this.readModuleInventory(tag);
        this.moduleStates = this.readModuleStates(tag);
        this.readOptions(tag);
        this.owner.load(tag);
        this.passcode = tag.m_128461_("passcode");
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        this.handleUpdateTag(packet.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            ItemStack stack = this.getModule(ModuleType.DISGUISE);
            if (!stack.m_41619_()) {
                ClientHandler.putDisguisedBeRenderer((BlockEntity)this, stack);
            } else {
                ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf((BlockEntity)this);
            }
        }
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return BlockUtils.getProtectedCapability(side, (BlockEntity)this, () -> super.getCapability(cap, side), () -> this.getInsertOnlyHandler()).cast();
        }
        return super.getCapability(cap, side);
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyInvWrapper((Container)this));
        }
        return this.insertOnlyHandler;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (ItemStack)this.f_58310_.get(slot);
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof AbstractKeypadFurnaceBlock) {
            AbstractKeypadFurnaceBlock block2 = (AbstractKeypadFurnaceBlock)block;
            block2.activate(this, this.m_58900_(), this.f_58857_, this.f_58858_, player);
        }
    }

    @Override
    public void openPasswordGUI(Player player) {
        if (!this.f_58857_.f_46443_) {
            if (this.getPassword() != null) {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.CHECK_PASSWORD, this.f_58858_));
            } else if (this.getOwner().isOwner(player)) {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.SET_PASSWORD, this.f_58858_));
            } else {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)new TextComponent("SecurityCraft"), (MutableComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), ChatFormatting.DARK_RED);
            }
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState state, Player player) {
        this.activate(player);
        return true;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
        this.m_6596_();
    }

    public ContainerData getFurnaceData() {
        return this.f_58311_;
    }

    protected Component m_6820_() {
        return new TranslatableComponent(this.m_58900_().m_60734_().m_7705_());
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage};
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            BlockState state = this.m_58900_();
            if (!this.f_58857_.f_46443_) {
                SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDisguisableModel(this.f_58858_, true, stack, toggled));
                if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    this.f_58857_.m_186469_(this.f_58858_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)this.f_58857_));
                    this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
                }
            } else {
                ClientHandler.putDisguisedBeRenderer((BlockEntity)this, stack);
                if (state.getLightEmission((BlockGetter)this.f_58857_, this.f_58858_) > 0) {
                    this.f_58857_.m_7726_().m_7827_().m_142202_(this.f_58858_);
                }
            }
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_.f_46443_) {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(this.getBlockEntity());
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            if (!this.f_58857_.f_46443_) {
                BlockState state = this.m_58900_();
                SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDisguisableModel(this.f_58858_, false, stack, toggled));
                if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    this.f_58857_.m_186469_(this.f_58858_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)this.f_58857_));
                    this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
                }
            } else {
                ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf((BlockEntity)this);
                DisguisableBlock.getDisguisedBlockStateFromStack(stack).ifPresent(disguisedState -> {
                    if (disguisedState.getLightEmission((BlockGetter)this.f_58857_, this.f_58858_) > 0) {
                        this.f_58857_.m_7726_().m_7827_().m_142202_(this.f_58858_);
                    }
                });
            }
        }
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
        if (shouldBeEnabled) {
            this.onModuleInserted(this.getModule(module), module, true);
        } else {
            this.onModuleRemoved(this.getModule(module), module, true);
        }
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DisguisableDynamicBakedModel.DISGUISED_STATE_RL, (Object)Blocks.f_50016_.m_49966_()).build();
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }
}

