/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.mines.ClaymoreBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class ClaymoreBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    private Option.IntOption range = new Option.IntOption(() -> ((ClaymoreBlockEntity)this).m_58899_(), "range", 5, 1, 10, 1, true);
    private int cooldown = -1;

    public ClaymoreBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.CLAYMORE_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)ClaymoreBlock.DEACTIVATED)).booleanValue()) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (this.cooldown == 0) {
            ((ClaymoreBlock)state.m_60734_()).explode(level, pos);
            return;
        }
        Direction dir = (Direction)state.m_61143_((Property)ClaymoreBlock.FACING);
        AABB area = switch (dir) {
            case Direction.NORTH -> new AABB(pos).m_82310_(0.0, 0.0, (double)((Integer)this.range.get()).intValue());
            case Direction.SOUTH -> new AABB(pos).m_82310_(0.0, 0.0, (double)(-((Integer)this.range.get()).intValue()));
            case Direction.EAST -> new AABB(pos).m_82310_((double)(-((Integer)this.range.get()).intValue()), 0.0, 0.0);
            case Direction.WEST -> new AABB(pos).m_82310_((double)((Integer)this.range.get()).intValue(), 0.0, 0.0);
            default -> new AABB(pos);
        };
        level.m_6443_(LivingEntity.class, area, e -> !EntityUtils.isInvisible(e) && !e.m_5833_() && !EntityUtils.doesEntityOwn((Entity)e, level, pos)).stream().findFirst().ifPresent(entity -> {
            this.cooldown = 20;
            level.m_5594_(null, new BlockPos((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 0.6f);
        });
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeOptions(tag);
        tag.m_128405_("cooldown", this.cooldown);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.readOptions(tag);
        this.cooldown = tag.m_128451_("cooldown");
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range};
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[0];
    }
}

