/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.events;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockStateChangeEvent
extends Event {
    private final ServerLevel level;
    private final BlockPos pos;
    private final BlockState oldState;
    private final BlockState newState;

    public BlockStateChangeEvent(ServerLevel level, BlockPos pos, BlockState oldState, BlockState newState) {
        this.level = level;
        this.pos = pos;
        this.oldState = oldState;
        this.newState = newState;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockState getOldState() {
        return this.oldState;
    }

    public BlockState getNewState() {
        return this.newState;
    }

    public static final void onBlockStateChange(ServerLevel level, BlockPos pos, BlockState oldState, BlockState newState) {
        MinecraftForge.EVENT_BUS.post((Event)new BlockStateChangeEvent(level, pos, oldState, newState));
    }
}

