/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.content.contraptions.components.actors.BellMovementBehaviour;
import com.simibubi.create.content.contraptions.components.actors.CampfireMovementBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.DispenserMovementBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.DropperMovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.repack.registrate.util.nullness.NonNullConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.IRegistryDelegate;
import org.jetbrains.annotations.Nullable;

public class AllMovementBehaviours {
    private static final Map<IRegistryDelegate<Block>, MovementBehaviour> BLOCK_BEHAVIOURS = new HashMap<IRegistryDelegate<Block>, MovementBehaviour>();
    private static final List<BehaviourProvider> GLOBAL_BEHAVIOURS = new ArrayList<BehaviourProvider>();

    public static void registerBehaviour(IRegistryDelegate<Block> block, MovementBehaviour behaviour) {
        BLOCK_BEHAVIOURS.put(block, behaviour);
    }

    public static void registerBehaviourProvider(BehaviourProvider provider) {
        GLOBAL_BEHAVIOURS.add(provider);
    }

    @Nullable
    public static MovementBehaviour getBehaviour(BlockState state) {
        MovementBehaviour behaviour = BLOCK_BEHAVIOURS.get(state.m_60734_().delegate);
        if (behaviour != null) {
            return behaviour;
        }
        for (BehaviourProvider provider : GLOBAL_BEHAVIOURS) {
            behaviour = provider.getBehaviour(state);
            if (behaviour == null) continue;
            return behaviour;
        }
        return null;
    }

    public static <B extends Block> NonNullConsumer<? super B> movementBehaviour(MovementBehaviour behaviour) {
        return b -> AllMovementBehaviours.registerBehaviour((IRegistryDelegate<Block>)b.delegate, behaviour);
    }

    static void registerDefaults() {
        AllMovementBehaviours.registerBehaviour((IRegistryDelegate<Block>)Blocks.f_50680_.delegate, new BellMovementBehaviour());
        AllMovementBehaviours.registerBehaviour((IRegistryDelegate<Block>)Blocks.f_50683_.delegate, new CampfireMovementBehaviour());
        DispenserMovementBehaviour.gatherMovedDispenseItemBehaviours();
        AllMovementBehaviours.registerBehaviour((IRegistryDelegate<Block>)Blocks.f_50061_.delegate, new DispenserMovementBehaviour());
        AllMovementBehaviours.registerBehaviour((IRegistryDelegate<Block>)Blocks.f_50286_.delegate, new DropperMovementBehaviour());
    }

    public static interface BehaviourProvider {
        @Nullable
        public MovementBehaviour getBehaviour(BlockState var1);
    }
}

