/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstance;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.simibubi.create.content.logistics.trains.entity.BogeyInstance;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.CarriageBogey;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntityRenderer;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;

public class CarriageContraptionInstance
extends EntityInstance<CarriageContraptionEntity>
implements DynamicInstance {
    private final PoseStack ms = new PoseStack();
    private Carriage carriage;
    private Couple<BogeyInstance> bogeys;
    private Couple<Boolean> bogeyHidden = Couple.create(() -> false);

    public CarriageContraptionInstance(MaterialManager materialManager, CarriageContraptionEntity entity) {
        super(materialManager, (Entity)entity);
        entity.bindInstance(this);
    }

    public void init() {
        this.carriage = ((CarriageContraptionEntity)this.entity).getCarriage();
        if (this.carriage == null) {
            return;
        }
        this.bogeys = this.carriage.bogeys.mapNotNullWithParam(CarriageBogey::createInstance, this.materialManager);
        this.updateLight();
    }

    public void setBogeyVisibility(boolean first, boolean visible) {
        this.bogeyHidden.set(first, !visible);
    }

    public void beginFrame() {
        if (this.bogeys == null) {
            if (((CarriageContraptionEntity)this.entity).isReadyForRender()) {
                this.init();
            }
            return;
        }
        float partialTicks = AnimationTickHolder.getPartialTicks();
        float viewYRot = ((CarriageContraptionEntity)this.entity).m_5675_(partialTicks);
        float viewXRot = ((CarriageContraptionEntity)this.entity).m_5686_(partialTicks);
        int bogeySpacing = this.carriage.bogeySpacing;
        this.ms.m_85836_();
        Vector3f instancePosition = this.getInstancePosition(partialTicks);
        TransformStack.cast((PoseStack)this.ms).translate(instancePosition);
        for (boolean current : Iterate.trueAndFalse) {
            BogeyInstance instance = this.bogeys.get(current);
            if (instance == null) continue;
            if (this.bogeyHidden.get(current).booleanValue()) {
                instance.hiddenFrame();
                continue;
            }
            this.ms.m_85836_();
            CarriageBogey bogey = instance.bogey;
            CarriageContraptionEntityRenderer.translateBogey(this.ms, bogey, bogeySpacing, viewYRot, viewXRot, partialTicks);
            this.ms.m_85837_(0.0, -1.5078125, 0.0);
            instance.beginFrame(bogey.wheelAngle.getValue(partialTicks), this.ms);
            this.ms.m_85849_();
        }
        this.ms.m_85849_();
    }

    public void updateLight() {
        if (this.bogeys == null) {
            return;
        }
        this.bogeys.forEach(instance -> {
            if (instance != null) {
                instance.updateLight((BlockAndTintGetter)this.world, (CarriageContraptionEntity)this.entity);
            }
        });
    }

    public void remove() {
        if (this.bogeys == null) {
            return;
        }
        this.bogeys.forEach(instance -> {
            if (instance != null) {
                instance.remove();
            }
        });
    }

    public boolean decreaseFramerateWithDistance() {
        return false;
    }
}

