/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.element.AnimatedOverlayElement;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.Pointing;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class InputWindowElement
extends AnimatedOverlayElement {
    private Pointing direction;
    ResourceLocation key;
    AllIcons icon;
    ItemStack item = ItemStack.f_41583_;
    private Vec3 sceneSpace;

    public InputWindowElement clone() {
        InputWindowElement inputWindowElement = new InputWindowElement(this.sceneSpace, this.direction);
        inputWindowElement.key = this.key;
        inputWindowElement.icon = this.icon;
        inputWindowElement.item = this.item.m_41777_();
        return inputWindowElement;
    }

    public InputWindowElement(Vec3 sceneSpace, Pointing direction) {
        this.sceneSpace = sceneSpace;
        this.direction = direction;
    }

    public InputWindowElement withItem(ItemStack stack) {
        this.item = stack;
        return this;
    }

    public InputWindowElement withWrench() {
        this.item = AllItems.WRENCH.asStack();
        return this;
    }

    public InputWindowElement scroll() {
        this.icon = AllIcons.I_SCROLL;
        return this;
    }

    public InputWindowElement rightClick() {
        this.icon = AllIcons.I_RMB;
        return this;
    }

    public InputWindowElement showing(AllIcons icon) {
        this.icon = icon;
        return this;
    }

    public InputWindowElement leftClick() {
        this.icon = AllIcons.I_LMB;
        return this;
    }

    public InputWindowElement whileSneaking() {
        this.key = Create.asResource("sneak_and");
        return this;
    }

    public InputWindowElement whileCTRL() {
        this.key = Create.asResource("ctrl_and");
        return this;
    }

    @Override
    protected void render(PonderScene scene, PonderUI screen, PoseStack ms, float partialTicks, float fade) {
        String text;
        float xFade;
        Font font = screen.getFontRenderer();
        int width = 0;
        int height = 0;
        float f = this.direction == Pointing.RIGHT ? -1.0f : (xFade = this.direction == Pointing.LEFT ? 1.0f : 0.0f);
        float yFade = this.direction == Pointing.DOWN ? -1.0f : (this.direction == Pointing.UP ? 1.0f : 0.0f);
        xFade *= 10.0f * (1.0f - fade);
        yFade *= 10.0f * (1.0f - fade);
        boolean hasItem = !this.item.m_41619_();
        boolean hasText = this.key != null;
        boolean hasIcon = this.icon != null;
        int keyWidth = 0;
        String string = text = hasText ? PonderLocalization.getShared(this.key) : "";
        if (fade < 0.0625f) {
            return;
        }
        Vec2 sceneToScreen = scene.getTransform().sceneToScreen(this.sceneSpace, partialTicks);
        if (hasIcon) {
            width += 24;
            height = 24;
        }
        if (hasText) {
            keyWidth = font.m_92895_(text);
            width += keyWidth;
        }
        if (hasItem) {
            width += 24;
            height = 24;
        }
        ms.m_85836_();
        ms.m_85837_((double)(sceneToScreen.f_82470_ + xFade), (double)(sceneToScreen.f_82471_ + yFade), 400.0);
        PonderUI.renderSpeechBox(ms, 0, 0, width, height, false, this.direction, true);
        ms.m_85837_(0.0, 0.0, 100.0);
        if (hasText) {
            Objects.requireNonNull(font);
            font.m_92883_(ms, text, 2.0f, (float)(height - 9) / 2.0f + 2.0f, PonderPalette.WHITE.getColorObject().scaleAlpha(fade).getRGB());
        }
        if (hasIcon) {
            ms.m_85836_();
            ms.m_85837_((double)keyWidth, 0.0, 0.0);
            ms.m_85841_(1.5f, 1.5f, 1.5f);
            this.icon.render(ms, 0, 0, (GuiComponent)screen);
            ms.m_85849_();
        }
        if (hasItem) {
            ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(this.item).at(keyWidth + (hasIcon ? 24 : 0), 0.0f)).scale(1.5).render(ms);
            RenderSystem.m_69465_();
        }
        ms.m_85849_();
    }
}

