/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.TraderClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.common.TraderInteractionTab;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageCollectCoins;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.util.NonNullSupplier;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class TraderScreen
extends AbstractContainerScreen<TraderMenu> {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/trader.png");
    public static final int WIDTH = 206;
    public static final int HEIGHT = 236;
    Button buttonOpenStorage;
    Button buttonCollectCoins;
    Button buttonOpenTerminal;
    List<AbstractWidget> tabRenderables = new ArrayList<AbstractWidget>();
    List<GuiEventListener> tabListeners = new ArrayList<GuiEventListener>();
    TraderClientTab currentTab = new TraderInteractionTab(this);

    public void setTab(@Nonnull TraderClientTab tab) {
        this.currentTab.onClose();
        this.tabRenderables.clear();
        this.tabListeners.clear();
        this.currentTab = tab;
        this.currentTab.onOpen();
    }

    public void closeTab() {
        this.setTab(new TraderInteractionTab(this));
    }

    public TraderScreen(TraderMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 206;
        this.f_97727_ = 236;
    }

    public void m_7856_() {
        super.m_7856_();
        this.tabRenderables.clear();
        this.tabListeners.clear();
        this.buttonOpenStorage = (Button)this.m_142416_((GuiEventListener)IconAndButtonUtil.storageButton(this.f_97735_, this.f_97736_ - 20, this::OpenStorage, (NonNullSupplier<Boolean>)((NonNullSupplier)() -> ((TraderMenu)this.f_97732_).isSingleTrader() && ((TraderMenu)this.f_97732_).getSingleTrader().hasPermission(((TraderMenu)this.f_97732_).player, "openStorage"))));
        this.buttonCollectCoins = (Button)this.m_142416_((GuiEventListener)IconAndButtonUtil.collectCoinButton(this.f_97735_ + 20, this.f_97736_ - 20, this::CollectCoins, ((TraderMenu)this.f_97732_).player, ((TraderMenu)this.f_97732_)::getSingleTrader));
        this.buttonOpenTerminal = (Button)this.m_142416_((GuiEventListener)IconAndButtonUtil.backToTerminalButton(this.f_97735_ + 15 - 20, this.f_97736_ + this.f_97727_ - 20, this::OpenTerminal, (NonNullSupplier<Boolean>)((NonNullSupplier)((TraderMenu)this.f_97732_)::isUniversalTrader)));
        this.currentTab.onOpen();
        this.m_181908_();
    }

    protected void m_7286_(PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(pose, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        for (Slot slot : ((TraderMenu)this.f_97732_).getCoinSlots()) {
            this.m_93228_(pose, this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, this.f_97726_, 0, 18, 18);
        }
        if (((TraderMenu)this.f_97732_).getInteractionSlot().m_6659_()) {
            this.m_93228_(pose, this.f_97735_ + ((TraderMenu)this.f_97732_).getInteractionSlot().f_40220_ - 1, this.f_97736_ + ((TraderMenu)this.f_97732_).getInteractionSlot().f_40221_ - 1, this.f_97726_, 0, 18, 18);
        }
        try {
            this.currentTab.renderBG(pose, mouseX, mouseY, partialTicks);
            this.tabRenderables.forEach(widget -> widget.m_6305_(pose, mouseX, mouseY, partialTicks));
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error rendering trader tab " + this.currentTab.getClass().getName(), t);
        }
    }

    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(pose, this.f_169604_, 23.0f, (float)(this.f_97727_ - 94), 0x404040);
        String valueText = MoneyUtil.getStringOfValue(((TraderMenu)this.f_97732_).getContext(null).getAvailableFunds());
        this.f_96547_.m_92883_(pose, valueText, (float)(185 - this.f_96547_.m_92895_(valueText)), (float)(this.f_97727_ - 94), 0x404040);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pose);
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.m_7025_(pose, mouseX, mouseY);
        try {
            this.currentTab.renderTooltips(pose, mouseX, mouseY);
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error rendering trader tab tooltips " + this.currentTab.getClass().getName(), t);
        }
        IconAndButtonUtil.renderButtonTooltips(pose, mouseX, mouseY, this.f_169369_);
    }

    public void m_181908_() {
        this.currentTab.tick();
    }

    private void OpenStorage(Button button) {
        if (((TraderMenu)this.f_97732_).isSingleTrader()) {
            ((TraderMenu)this.f_97732_).getSingleTrader().sendOpenStorageMessage();
        }
    }

    private void CollectCoins(Button button) {
        if (((TraderMenu)this.f_97732_).isSingleTrader()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCollectCoins());
        }
    }

    private void OpenTerminal(Button button) {
        if (((TraderMenu)this.f_97732_).isUniversalTrader()) {
            ((TraderMenu)this.f_97732_).player.m_6915_();
            LightmansCurrency.PROXY.openTerminalScreen();
        }
    }

    public boolean m_7933_(int p_97765_, int p_97766_, int p_97767_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_97765_, (int)p_97766_);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && this.currentTab.blockInventoryClosing()) {
            return true;
        }
        return super.m_7933_(p_97765_, p_97766_, p_97767_);
    }

    public <T extends AbstractWidget> T addRenderableTabWidget(T widget) {
        this.tabRenderables.add(widget);
        return widget;
    }

    public <T extends Widget> void removeRenderableTabWidget(T widget) {
        this.tabRenderables.remove(widget);
    }

    public <T extends GuiEventListener> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public <T extends GuiEventListener> void removeTabListener(T listener) {
        this.tabListeners.remove(listener);
    }

    public List<? extends GuiEventListener> m_6702_() {
        List coreListeners = super.m_6702_();
        ArrayList listeners = Lists.newArrayList();
        for (int i = 0; i < coreListeners.size(); ++i) {
            listeners.add((GuiEventListener)coreListeners.get(i));
        }
        listeners.addAll(this.tabRenderables);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        try {
            if (this.currentTab.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        try {
            if (this.currentTab.mouseReleased(mouseX, mouseY, button)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.m_6348_(mouseX, mouseY, button);
    }
}

