/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.PaygateBlockEntity;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.items.TicketItem;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;

public class PaygateTradeData
extends TradeData {
    int duration = 1;
    UUID ticketID = null;

    public int getDuration() {
        return Math.max(this.duration, 1);
    }

    public void setDuration(int duration) {
        this.duration = Math.max(duration, 1);
    }

    public boolean isTicketTrade() {
        return this.ticketID != null;
    }

    public UUID getTicketID() {
        return this.ticketID;
    }

    public void setTicketID(UUID ticketID) {
        this.ticketID = ticketID;
    }

    @Override
    public TradeData.TradeDirection getTradeDirection() {
        return TradeData.TradeDirection.SALE;
    }

    public boolean canAfford(TradeContext context) {
        if (this.isTicketTrade()) {
            return context.hasTicket(this.ticketID);
        }
        return context.hasFunds(this.cost);
    }

    @Override
    public boolean isValid() {
        return this.getDuration() >= 1 && (this.isTicketTrade() || super.isValid());
    }

    public static CompoundTag saveAllData(CompoundTag nbt, List<PaygateTradeData> data) {
        return PaygateTradeData.saveAllData(nbt, data, "Trades");
    }

    public static CompoundTag saveAllData(CompoundTag nbt, List<PaygateTradeData> data, String key) {
        ListTag listNBT = new ListTag();
        for (int i = 0; i < data.size(); ++i) {
            listNBT.add((Object)data.get(i).getAsNBT());
        }
        if (listNBT.size() > 0) {
            nbt.m_128365_(key, (Tag)listNBT);
        }
        return nbt;
    }

    public static PaygateTradeData loadData(CompoundTag nbt) {
        PaygateTradeData trade = new PaygateTradeData();
        trade.loadFromNBT(nbt);
        return trade;
    }

    public static List<PaygateTradeData> loadAllData(CompoundTag nbt, int arraySize) {
        return PaygateTradeData.loadAllData("Trades", nbt, arraySize);
    }

    public static List<PaygateTradeData> loadAllData(String key, CompoundTag nbt, int arraySize) {
        ListTag listNBT = nbt.m_128437_(key, 10);
        List<PaygateTradeData> data = PaygateTradeData.listOfSize(arraySize);
        for (int i = 0; i < listNBT.size() && i < arraySize; ++i) {
            data.get(i).loadFromNBT(listNBT.m_128728_(i));
        }
        return data;
    }

    public static List<PaygateTradeData> listOfSize(int tradeCount) {
        ArrayList data = Lists.newArrayList();
        while (data.size() < tradeCount) {
            data.add(new PaygateTradeData());
        }
        return data;
    }

    @Override
    public CompoundTag getAsNBT() {
        CompoundTag compound = super.getAsNBT();
        compound.m_128405_("Duration", this.getDuration());
        if (this.ticketID != null) {
            compound.m_128362_("Ticket", this.ticketID);
        }
        return compound;
    }

    @Override
    protected void loadFromNBT(CompoundTag compound) {
        super.loadFromNBT(compound);
        this.duration = compound.m_128451_("Duration");
        this.ticketID = compound.m_128441_("Ticket") ? compound.m_128342_("Ticket") : null;
    }

    @Override
    public TradeData.TradeComparisonResult compare(TradeData otherTrade) {
        LightmansCurrency.LogWarning("Attempting to compare paygate trades, but paygate trades do not support this interaction.");
        return new TradeData.TradeComparisonResult();
    }

    @Override
    public boolean AcceptableDifferences(TradeData.TradeComparisonResult result) {
        LightmansCurrency.LogWarning("Attempting to determine if the paygate trades differences are acceptable, but paygate trades do not support this interaction.");
        return false;
    }

    @Override
    public List<Component> GetDifferenceWarnings(TradeData.TradeComparisonResult differences) {
        LightmansCurrency.LogWarning("Attempting to get warnings for different paygate trades, but paygate trades do not support this interaction.");
        return Lists.newArrayList();
    }

    @Override
    public int tradeButtonWidth(TradeContext context) {
        return 94;
    }

    @Override
    public int tradeButtonHeight(TradeContext context) {
        return 18;
    }

    @Override
    public TradeButton.DisplayData inputDisplayArea(TradeContext context) {
        return new TradeButton.DisplayData(1, 1, 34, 16);
    }

    @Override
    public TradeButton.DisplayData outputDisplayArea(TradeContext context) {
        return new TradeButton.DisplayData(58, 1, 34, 16);
    }

    @Override
    public Pair<Integer, Integer> arrowPosition(TradeContext context) {
        return Pair.of((Object)36, (Object)1);
    }

    @Override
    public Pair<Integer, Integer> alertPosition(TradeContext context) {
        return Pair.of((Object)36, (Object)1);
    }

    @Override
    public List<TradeButton.DisplayEntry> getInputDisplays(TradeContext context) {
        if (this.isTicketTrade()) {
            return Lists.newArrayList((Object[])new TradeButton.DisplayEntry[]{TradeButton.DisplayEntry.of(TicketItem.CreateTicket(this.ticketID), 1, (List<Component>)Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("tooltip.lightmanscurrency.ticket.id", new Object[]{this.ticketID})}))});
        }
        return Lists.newArrayList((Object[])new TradeButton.DisplayEntry[]{TradeButton.DisplayEntry.of(this.getCost(context), context.isStorageMode ? Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("tooltip.lightmanscurrency.trader.price_edit")}) : null)});
    }

    @Override
    public List<TradeButton.DisplayEntry> getOutputDisplays(TradeContext context) {
        return Lists.newArrayList((Object[])new TradeButton.DisplayEntry[]{TradeButton.DisplayEntry.of((Component)PaygateTradeData.formatDurationDisplay(this.duration), TextRenderUtil.TextFormatting.create(), (List<Component>)Lists.newArrayList((Object[])new Component[]{PaygateTradeData.formatDuration(this.getDuration())}))});
    }

    public static MutableComponent formatDurationShort(int duration) {
        int ticks = duration % 20;
        int seconds = duration / 20 % 60;
        int minutes = duration / 1200 % 60;
        int hours = duration / 72000;
        TextComponent result = new TextComponent("");
        if (hours > 0) {
            result.m_7220_((Component)new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.hours.short", new Object[]{hours}));
        }
        if (minutes > 0) {
            result.m_7220_((Component)new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.minutes.short", new Object[]{minutes}));
        }
        if (seconds > 0) {
            result.m_7220_((Component)new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.seconds.short", new Object[]{seconds}));
        }
        if (ticks > 0 || result.getString().isBlank()) {
            result.m_7220_((Component)new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.ticks.short", new Object[]{ticks}));
        }
        return result;
    }

    public static MutableComponent formatDurationDisplay(int duration) {
        int ticks = duration % 20;
        int seconds = duration / 20 % 60;
        int minutes = duration / 1200 % 60;
        int hours = duration / 72000;
        if (hours > 0) {
            return new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.hours.short", new Object[]{hours});
        }
        if (minutes > 0) {
            return new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.minutes.short", new Object[]{minutes});
        }
        if (seconds > 0) {
            return new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.seconds.short", new Object[]{seconds});
        }
        return new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.ticks.short", new Object[]{ticks});
    }

    public static MutableComponent formatDuration(int duration) {
        int ticks = duration % 20;
        int seconds = duration / 20 % 60;
        int minutes = duration / 1200 % 60;
        int hours = duration / 72000;
        TextComponent result = new TextComponent("");
        boolean addSpacer = false;
        if (hours > 0) {
            if (addSpacer) {
                result.m_7220_((Component)new TextComponent(" "));
            }
            addSpacer = true;
            if (hours > 1) {
                result.m_7220_((Component)new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.hours", new Object[]{hours}));
            } else {
                result.m_7220_((Component)new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.hours.singular", new Object[]{hours}));
            }
        }
        if (minutes > 0) {
            if (addSpacer) {
                result.m_7220_((Component)new TextComponent(" "));
            }
            addSpacer = true;
            if (minutes > 1) {
                result.m_7220_((Component)new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.minutes", new Object[]{minutes}));
            } else {
                result.m_7220_((Component)new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.minutes.singular", new Object[]{minutes}));
            }
        }
        if (seconds > 0) {
            if (addSpacer) {
                result.m_7220_((Component)new TextComponent(" "));
            }
            addSpacer = true;
            if (seconds > 1) {
                result.m_7220_((Component)new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.seconds", new Object[]{seconds}));
            } else {
                result.m_7220_((Component)new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.seconds.singular", new Object[]{seconds}));
            }
        }
        if (ticks > 0) {
            if (addSpacer) {
                result.m_7220_((Component)new TextComponent(" "));
            }
            addSpacer = true;
            if (ticks > 1) {
                result.m_7220_((Component)new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.ticks", new Object[]{ticks}));
            } else {
                result.m_7220_((Component)new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration.ticks.singular", new Object[]{ticks}));
            }
        }
        return result;
    }

    @Override
    public List<AlertData> getAlertData(TradeContext context) {
        if (context.isStorageMode) {
            return null;
        }
        ArrayList<AlertData> alerts = new ArrayList<AlertData>();
        if (context.hasTrader() && context.getTrader() instanceof PaygateBlockEntity) {
            PaygateBlockEntity paygate = (PaygateBlockEntity)context.getTrader();
            if (paygate.isActive()) {
                alerts.add(AlertData.warn((MutableComponent)new TranslatableComponent("tooltip.lightmanscurrency.paygate.active")));
            }
            if (!this.canAfford(context)) {
                alerts.add(AlertData.warn((MutableComponent)new TranslatableComponent("tooltip.lightmanscurrency.cannotafford")));
            }
        }
        this.addTradeRuleAlertData(alerts, context);
        return alerts;
    }

    @Override
    public void onInputDisplayInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int index, int button, ItemStack heldItem) {
        if (tab.menu.getTrader() instanceof PaygateBlockEntity) {
            PaygateBlockEntity paygate = (PaygateBlockEntity)tab.menu.getTrader();
            int tradeIndex = paygate.getAllTrades().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            if (heldItem.m_41720_() == ModItems.TICKET_MASTER) {
                this.setTicketID(TicketItem.GetTicketID(heldItem));
                if (tab.menu.isClient()) {
                    tab.sendInputInteractionMessage(tradeIndex, 0, button, heldItem);
                }
            } else {
                CompoundTag extraData = new CompoundTag();
                extraData.m_128405_("TradeIndex", tradeIndex);
                tab.sendOpenTabMessage(2, extraData);
            }
        }
    }

    @Override
    public void onOutputDisplayInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int index, int button, ItemStack heldItem) {
        if (tab.menu.getTrader() instanceof PaygateBlockEntity) {
            PaygateBlockEntity paygate = (PaygateBlockEntity)tab.menu.getTrader();
            int tradeIndex = paygate.getAllTrades().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            CompoundTag extraData = new CompoundTag();
            extraData.m_128405_("TradeIndex", tradeIndex);
            tab.sendOpenTabMessage(2, extraData);
        }
    }

    @Override
    public void onInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int mouseX, int mouseY, int button, ItemStack heldItem) {
        if (tab.menu.getTrader() instanceof PaygateBlockEntity) {
            PaygateBlockEntity paygate = (PaygateBlockEntity)tab.menu.getTrader();
            int tradeIndex = paygate.getAllTrades().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            CompoundTag extraData = new CompoundTag();
            extraData.m_128405_("TradeIndex", tradeIndex);
            tab.sendOpenTabMessage(2, extraData);
        }
    }
}

