/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.mehvahdjukaar.supplementaries.client.TextUtil;
import net.mehvahdjukaar.supplementaries.client.renderers.LOD;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.client.renderers.RotHlpr;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.HangingSignBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundRequestMapDataPacket;
import net.mehvahdjukaar.supplementaries.setup.ClientRegistry;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.ComplexItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class HangingSignBlockTileRenderer
implements BlockEntityRenderer<HangingSignBlockTile> {
    public static final int LINE_MAX_WIDTH = 75;
    public static final int LINE_SEPARATION = 10;
    private final BlockRenderDispatcher blockRenderer;
    private final ItemRenderer itemRenderer;
    private final MapRenderer mapRenderer;
    private final Camera camera;
    private final Font font;

    public HangingSignBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.blockRenderer = context.m_173584_();
        this.itemRenderer = minecraft.m_91291_();
        this.mapRenderer = minecraft.f_91063_.m_109151_();
        this.camera = minecraft.f_91063_.m_109153_();
        this.font = context.m_173586_();
    }

    public void render(HangingSignBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        poseStack.m_85836_();
        BlockState state = tile.m_58900_();
        BlockProperties.SignAttachment attachment = (BlockProperties.SignAttachment)((Object)state.m_61143_(BlockProperties.SIGN_ATTACHMENT));
        double dy = attachment == BlockProperties.SignAttachment.CEILING ? 1.0 : 0.875;
        poseStack.m_85837_(0.5, dy, 0.5);
        if (state.m_61143_(HangingSignBlock.AXIS) == Direction.Axis.X) {
            poseStack.m_85845_(RotHlpr.Y90);
        }
        if (tile.shouldRenderFancy()) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(tile.getSwingAngle(partialTicks)));
            poseStack.m_85837_(-0.5, -0.875, -0.5);
            RendererUtil.renderBlockModel(ClientRegistry.HANGING_SIGNS_BLOCK_MODELS.get(tile.woodType), poseStack, bufferIn, this.blockRenderer, combinedLightIn, combinedOverlayIn, true);
        } else {
            poseStack.m_85837_(-0.5, -0.875, -0.5);
        }
        LOD lod = new LOD(this.camera, tile.m_58899_());
        tile.setFancyRenderer(lod.isNear());
        if (lod.isMedium()) {
            poseStack.m_85837_(0.5, 0.3125, 0.5);
            poseStack.m_85845_(RotHlpr.YN90);
            if (!tile.isEmpty()) {
                ItemStack stack = tile.getStackInSlot(0);
                Item item2 = stack.m_41720_();
                if (item2 instanceof ComplexItem) {
                    MapItemSavedData mapData = MapItem.m_42853_((ItemStack)stack, (Level)tile.m_58904_());
                    if (mapData != null) {
                        for (int v = 0; v < 2; ++v) {
                            poseStack.m_85836_();
                            poseStack.m_85837_(0.0, 0.0, 0.0675);
                            poseStack.m_85841_(0.0068359375f, -0.0068359375f, -0.0068359375f);
                            poseStack.m_85837_(-64.0, -64.0, 0.0);
                            Integer mapId = MapItem.m_151131_((ItemStack)stack);
                            this.mapRenderer.m_168771_(poseStack, bufferIn, mapId.intValue(), mapData, true, combinedLightIn);
                            poseStack.m_85849_();
                            poseStack.m_85845_(RotHlpr.Y180);
                        }
                    } else {
                        LocalPlayer player = Minecraft.m_91087_().f_91074_;
                        NetworkHandler.INSTANCE.sendToServer((Object)new ServerBoundRequestMapDataPacket(tile.m_58899_(), player.m_142081_()));
                    }
                } else if (item2 instanceof BannerPatternItem) {
                    Material renderMaterial = ClientRegistry.FLAG_MATERIALS.get(((BannerPatternItem)item2).m_40555_());
                    VertexConsumer builder = renderMaterial.m_119194_(bufferIn, RenderType::m_110482_);
                    float[] color = tile.textHolder.getColor().m_41068_();
                    float b = color[2];
                    float g = color[1];
                    float r = color[0];
                    int lu = combinedLightIn & 0xFFFF;
                    int lv = combinedLightIn >> 16 & 0xFFFF;
                    for (int v = 0; v < 2; ++v) {
                        RendererUtil.addQuadSide(builder, poseStack, -0.4375f, -0.4375f, 0.0725f, 0.4375f, 0.4375f, 0.07f, 0.15625f, 0.0625f, 0.59375f, 0.9375f, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f, renderMaterial.m_119204_());
                        poseStack.m_85845_(RotHlpr.Y180);
                    }
                } else {
                    BakedModel model = this.itemRenderer.m_174264_(stack, tile.m_58904_(), null, 0);
                    for (int v = 0; v < 2; ++v) {
                        poseStack.m_85836_();
                        poseStack.m_85841_(0.75f, 0.75f, 0.75f);
                        poseStack.m_85837_(0.0, 0.0, -0.1);
                        this.itemRenderer.m_115143_(stack, ItemTransforms.TransformType.FIXED, true, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, model);
                        poseStack.m_85849_();
                        poseStack.m_85845_(RotHlpr.Y180);
                        poseStack.m_85841_(0.9995f, 0.9995f, 0.9995f);
                    }
                }
            } else if (lod.isNearMed()) {
                poseStack.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
                TextUtil.RenderTextProperties textProperties = new TextUtil.RenderTextProperties(tile.getTextHolder(), combinedLightIn, lod::isVeryNear);
                for (int v = 0; v < 2; ++v) {
                    poseStack.m_85836_();
                    poseStack.m_85837_(0.0, -34.0, 6.479999806880957);
                    TextUtil.renderAllLines(tile.textHolder, 10, this.font, 75, poseStack, bufferIn, textProperties);
                    poseStack.m_85849_();
                    poseStack.m_85845_(RotHlpr.Y180);
                }
            }
        }
        poseStack.m_85849_();
    }
}

