/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CandleSkullBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.EnhancedSkullBlockTile;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;

public class DoubleSkullBlockTile
extends EnhancedSkullBlockTile {
    @Nullable
    protected SkullBlockEntity innerTileUp = null;
    private int waxColorInd = -1;
    private ResourceLocation waxTexture = null;

    public DoubleSkullBlockTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModRegistry.SKULL_PILE_TILE.get(), pWorldPosition, pBlockState);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.saveInnerTile("SkullUp", this.innerTileUp, tag);
        if (this.waxColorInd != -1) {
            tag.m_128405_("WaxColor", this.waxColorInd);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.innerTileUp = this.loadInnerTile("SkullUp", this.innerTileUp, tag);
        if (tag.m_128441_("WaxColor")) {
            this.waxColorInd = tag.m_128451_("WaxColor");
            DyeColor d = this.waxColorInd == 17 ? null : DyeColor.m_41053_((int)this.waxColorInd);
            this.waxTexture = Textures.SKULL_CANDLES_TEXTURES.get(d);
        } else {
            this.waxTexture = null;
        }
    }

    public ItemStack getSkullItemUp() {
        if (this.innerTileUp != null) {
            return new ItemStack((ItemLike)this.innerTileUp.m_58900_().m_60734_());
        }
        return ItemStack.f_41583_;
    }

    public void rotateUp(Rotation rotation) {
        if (this.innerTileUp != null) {
            BlockState state = this.innerTileUp.m_58900_();
            int r = (Integer)this.innerTileUp.m_58900_().m_61143_((Property)SkullBlock.f_56314_);
            this.innerTileUp.m_155250_((BlockState)state.m_61124_((Property)SkullBlock.f_56314_, (Comparable)Integer.valueOf(rotation.m_55949_(r, 16))));
        }
    }

    public void rotateUpStep(int step) {
        if (this.innerTileUp != null) {
            BlockState state = this.innerTileUp.m_58900_();
            int r = (Integer)this.innerTileUp.m_58900_().m_61143_((Property)SkullBlock.f_56314_);
            this.innerTileUp.m_155250_((BlockState)state.m_61124_((Property)SkullBlock.f_56314_, (Comparable)Integer.valueOf((r - step + 16) % 16)));
        }
    }

    @Override
    public void initialize(SkullBlockEntity oldTile, SkullBlock skullBlock, ItemStack skullStack, Player player, InteractionHand hand) {
        BlockItem bi;
        Block block2;
        super.initialize(oldTile, skullBlock, skullStack, player, hand);
        Item item2 = skullStack.m_41720_();
        if (item2 instanceof BlockItem && (block2 = (bi = (BlockItem)item2).m_40614_()) instanceof SkullBlock) {
            BlockEntity entity2;
            SkullBlock upSkull = (SkullBlock)block2;
            BlockPlaceContext context = new BlockPlaceContext(player, hand, skullStack, new BlockHitResult(new Vec3(0.5, 0.5, 0.5), Direction.UP, this.m_58899_(), false));
            BlockState state = upSkull.m_5573_(context);
            if (state == null) {
                state = upSkull.m_49966_();
            }
            if ((entity2 = upSkull.m_142194_(this.m_58899_(), state)) instanceof SkullBlockEntity) {
                SkullBlockEntity blockEntity;
                this.innerTileUp = blockEntity = (SkullBlockEntity)entity2;
                GameProfile gameprofile = null;
                if (skullStack.m_41782_()) {
                    CompoundTag compoundtag = skullStack.m_41783_();
                    if (compoundtag.m_128425_("SkullOwner", 10)) {
                        gameprofile = NbtUtils.m_129228_((CompoundTag)compoundtag.m_128469_("SkullOwner"));
                    } else if (compoundtag.m_128425_("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)compoundtag.m_128461_("SkullOwner"))) {
                        gameprofile = new GameProfile(null, compoundtag.m_128461_("SkullOwner"));
                    }
                }
                this.innerTileUp.m_59769_(gameprofile);
            }
        }
    }

    public void updateWax(BlockState above) {
        int index = -1;
        DyeColor c = null;
        Block block2 = above.m_60734_();
        if (block2 instanceof CandleBlock) {
            CandleBlock block3 = (CandleBlock)block2;
            c = CandleSkullBlockTile.colorFromCandle((Block)block3);
            index = c == null ? 17 : c.m_41060_();
        }
        if (this.waxColorInd != index) {
            this.waxColorInd = index;
            if (this.f_58857_ instanceof ServerLevel) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            } else {
                this.waxTexture = this.waxColorInd == -1 ? null : Textures.SKULL_CANDLES_TEXTURES.get(c);
            }
        }
    }

    public ResourceLocation getWaxTexture() {
        return this.waxTexture;
    }

    @Nullable
    public BlockState getSkullUp() {
        if (this.innerTileUp != null) {
            return this.innerTileUp.m_58900_();
        }
        return null;
    }

    @Nullable
    public BlockEntity getSkullTileUp() {
        return this.innerTileUp;
    }
}

