/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FeatherBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.MimicBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.common.util.Lazy;

public class FrameBlockTile
extends MimicBlockTile {
    public final Lazy<BlockState> WATTLE_AND_DAUB = Lazy.of(() -> ((FrameBlock)this.m_58900_().m_60734_()).daub.get().m_49966_());

    public FrameBlockTile(BlockPos pos, BlockState state) {
        this(pos, state, () -> null);
    }

    public FrameBlockTile(BlockPos pos, BlockState state, Supplier<Block> wattle_and_daub) {
        super((BlockEntityType)ModRegistry.TIMBER_FRAME_TILE.get(), pos, state);
    }

    @Override
    public boolean setHeldBlock(BlockState state) {
        this.mimic = state;
        if (this.f_58857_ instanceof ServerLevel) {
            this.m_6596_();
            int newLight = this.getLightValue();
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)((BlockState)this.m_58900_().m_61124_((Property)FrameBlock.HAS_BLOCK, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FrameBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(newLight)), 3);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
        return true;
    }

    public int getLightValue() {
        return this.getHeldBlock().m_60791_();
    }

    public BlockState acceptBlock(BlockState state) {
        Block b = state.m_60734_();
        if (b == ModRegistry.DAUB.get() && ServerConfigs.cached.REPLACE_DAUB) {
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                state = (BlockState)this.WATTLE_AND_DAUB.get();
                if (this.m_58900_().m_61138_((Property)BlockProperties.FLIPPED)) {
                    state = (BlockState)state.m_61124_((Property)BlockProperties.FLIPPED, (Comparable)((Boolean)this.m_58900_().m_61143_((Property)BlockProperties.FLIPPED)));
                }
                this.f_58857_.m_7731_(this.f_58858_, state, 3);
            }
        } else {
            this.setHeldBlock(state);
            if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
                ModelDataManager.requestModelDataRefresh((BlockEntity)this);
            }
        }
        return state;
    }

    public InteractionResult handleInteraction(Player player, InteractionHand hand, BlockHitResult trace) {
        ItemStack stack = player.m_21120_(hand);
        Item item2 = stack.m_41720_();
        if (player.m_150110_().f_35938_ && item2 instanceof BlockItem) {
            BlockState toPlace;
            BlockItem blockItem = (BlockItem)item2;
            if (this.getHeldBlock().m_60795_() && FrameBlockTile.isValidBlock(toPlace = blockItem.m_40614_().m_5573_(new BlockPlaceContext(player, hand, stack, trace)), this.f_58858_, this.f_58857_)) {
                BlockState newState = this.acceptBlock(toPlace);
                SoundType s = newState.getSoundType((LevelReader)this.f_58857_, this.f_58858_, (Entity)player);
                this.f_58857_.m_142346_((Entity)player, GameEvent.f_157792_, this.f_58858_);
                this.f_58857_.m_5594_(player, this.f_58858_, s.m_56777_(), SoundSource.BLOCKS, (s.m_56773_() + 1.0f) / 2.0f, s.m_56774_() * 0.8f);
                if (!player.m_7500_() && !this.f_58857_.m_5776_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
            }
        }
        return InteractionResult.FAIL;
    }

    public static boolean isValidBlock(@Nullable BlockState state, BlockPos pos, Level world) {
        if (state == null) {
            return false;
        }
        Block b = state.m_60734_();
        if (b == Blocks.f_50752_) {
            return false;
        }
        if (b == ModRegistry.DAUB_FRAME.get() || b == ModRegistry.DAUB_BRACE.get() || b == ModRegistry.DAUB_CROSS_BRACE.get()) {
            return false;
        }
        if (b instanceof EntityBlock) {
            return false;
        }
        if (b instanceof FeatherBlock) {
            return true;
        }
        return state.m_60804_((BlockGetter)world, pos) && Block.m_49916_((VoxelShape)state.m_60812_((BlockGetter)world, pos));
    }
}

