/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.inventories.PulleyBlockContainerMenu;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PulleyBlockTile
extends ItemDisplayTile {
    public PulleyBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.PULLEY_BLOCK_TILE.get(), pos, state);
    }

    public boolean needsToUpdateClientWhenChanged() {
        return false;
    }

    public void updateTileOnInventoryChanged() {
        BlockProperties.Winding type = PulleyBlockTile.getContentType(this.getDisplayedItem().m_41720_());
        BlockState state = this.m_58900_();
        if (state.m_61143_(PulleyBlock.TYPE) != type) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_(PulleyBlock.TYPE, (Comparable)((Object)type)));
        }
    }

    public static BlockProperties.Winding getContentType(Item item2) {
        BlockItem bi;
        BlockProperties.Winding type = BlockProperties.Winding.NONE;
        if (item2 instanceof BlockItem && (bi = (BlockItem)item2).m_40614_() instanceof ChainBlock || item2.m_204114_().m_203656_(ModTags.CHAINS)) {
            type = BlockProperties.Winding.CHAIN;
        } else if (item2.m_204114_().m_203656_(ModTags.ROPES)) {
            type = BlockProperties.Winding.ROPE;
        }
        return type;
    }

    public Component m_6820_() {
        return new TranslatableComponent("block.supplementaries.pulley_block");
    }

    public AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new PulleyBlockContainerMenu(id, player, (Container)this);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return PulleyBlockTile.getContentType(stack.m_41720_()) != BlockProperties.Winding.NONE;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int m_6893_() {
        return 64;
    }

    public boolean handleRotation(Rotation rot) {
        if (rot == Rotation.CLOCKWISE_90) {
            return this.pullUp(this.f_58858_, (LevelAccessor)this.f_58857_, 1);
        }
        return this.pullDown(this.f_58858_, (LevelAccessor)this.f_58857_, 1);
    }

    public boolean pullUp(BlockPos pos, LevelAccessor world, int rot) {
        if (!(world instanceof Level)) {
            return false;
        }
        ItemStack stack = this.getDisplayedItem();
        boolean addNewItem = false;
        if (stack.m_41619_()) {
            Item i = world.m_8055_(pos.m_7495_()).m_60734_().m_5456_();
            if (PulleyBlockTile.getContentType(i) == BlockProperties.Winding.NONE) {
                return false;
            }
            stack = new ItemStack((ItemLike)i);
            addNewItem = true;
        }
        if (stack.m_41613_() + rot > stack.m_41741_() || !(stack.m_41720_() instanceof BlockItem)) {
            return false;
        }
        Block ropeBlock = ((BlockItem)stack.m_41720_()).m_40614_();
        boolean success = RopeBlock.removeRope(pos.m_7495_(), (Level)world, ropeBlock);
        if (success) {
            SoundType soundtype = ropeBlock.m_49966_().getSoundType((LevelReader)world, pos, null);
            world.m_5594_(null, pos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            if (addNewItem) {
                this.setDisplayedItem(stack);
            } else {
                stack.m_41769_(1);
            }
            this.m_6596_();
        }
        return success;
    }

    public boolean pullDown(BlockPos pos, LevelAccessor world, int rot) {
        if (!(world instanceof Level)) {
            return false;
        }
        ItemStack stack = this.getDisplayedItem();
        if (stack.m_41613_() < rot || !(stack.m_41720_() instanceof BlockItem)) {
            return false;
        }
        Block ropeBlock = ((BlockItem)stack.m_41720_()).m_40614_();
        boolean success = RopeBlock.addRope(pos.m_7495_(), (Level)world, null, InteractionHand.MAIN_HAND, ropeBlock);
        if (success) {
            SoundType soundtype = ropeBlock.m_49966_().getSoundType((LevelReader)world, pos, null);
            world.m_5594_(null, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            stack.m_41774_(1);
            this.m_6596_();
        }
        return success;
    }
}

