/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.block_set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.selene.blocks.IOwnerProtected;
import net.mehvahdjukaar.supplementaries.client.gui.SignPostGui;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StickBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.MimicBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.util.TextHolder;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignPostBlockTile
extends MimicBlockTile
implements ITextHolderProvider,
IOwnerProtected {
    private UUID owner = null;
    public boolean framed = false;
    public static final ModelProperty<Boolean> FRAMED = BlockProperties.FRAMED;
    public TextHolder textHolder;
    public float yawUp = 0.0f;
    public float yawDown = 0.0f;
    public boolean leftUp = true;
    public boolean leftDown = false;
    public boolean up = false;
    public boolean down = false;
    public boolean isSlim = false;
    @NotNull
    public WoodType woodTypeUp = WoodType.OAK_WOOD_TYPE;
    @NotNull
    public WoodType woodTypeDown = WoodType.OAK_WOOD_TYPE;

    public SignPostBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.SIGN_POST_TILE.get(), pos, state);
        this.textHolder = new TextHolder(2);
    }

    @Override
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(FRAMED, (Object)this.framed).withInitial(MIMIC, (Object)this.getHeldBlock()).build();
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.isSlim = this.mimic.m_60734_() instanceof StickBlock;
    }

    @Override
    public TextHolder getTextHolder() {
        return this.textHolder;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_().m_142022_(-0.25, 0.0, -0.25), this.m_58899_().m_142022_(1.25, 1.0, 1.25));
    }

    public void pointToward(BlockPos targetPos, boolean up) {
        float yaw = (float)(Math.atan2(targetPos.m_123341_() - this.f_58858_.m_123341_(), targetPos.m_123343_() - this.f_58858_.m_123343_()) * 180.0 / Math.PI);
        if (up) {
            this.yawUp = Mth.m_14177_((float)(yaw - (float)(this.leftUp ? 180 : 0)));
        } else {
            this.yawDown = Mth.m_14177_((float)(yaw - (float)(this.leftDown ? 180 : 0)));
        }
    }

    public float getPointingYaw(boolean up) {
        if (up) {
            return Mth.m_14177_((float)(-this.yawUp - (float)(this.leftUp ? 180 : 0)));
        }
        return Mth.m_14177_((float)(-this.yawDown - (float)(this.leftDown ? 180 : 0)));
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.framed = compound.m_128471_("Framed");
        this.textHolder.read(compound);
        this.yawUp = compound.m_128457_("YawUp");
        this.yawDown = compound.m_128457_("YawDown");
        this.leftUp = compound.m_128471_("LeftUp");
        this.leftDown = compound.m_128471_("LeftDown");
        this.up = compound.m_128471_("Up");
        this.down = compound.m_128471_("Down");
        this.woodTypeUp = WoodTypeRegistry.fromNBT((String)compound.m_128461_("TypeUp"));
        this.woodTypeDown = WoodTypeRegistry.fromNBT((String)compound.m_128461_("TypeDown"));
        this.loadOwner(compound);
        this.isSlim = this.mimic.m_60734_() instanceof StickBlock;
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("Framed", this.framed);
        this.textHolder.write(compound);
        compound.m_128350_("YawUp", this.yawUp);
        compound.m_128350_("YawDown", this.yawDown);
        compound.m_128379_("LeftUp", this.leftUp);
        compound.m_128379_("LeftDown", this.leftDown);
        compound.m_128379_("Up", this.up);
        compound.m_128379_("Down", this.down);
        compound.m_128359_("TypeUp", this.woodTypeUp.toString());
        compound.m_128359_("TypeDown", this.woodTypeDown.toString());
        this.saveOwner(compound);
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public boolean rotateSign(boolean up, float angle, boolean constrainAngle) {
        if (up && this.up) {
            this.yawUp = Mth.m_14177_((float)(this.yawUp + angle));
            if (constrainAngle) {
                this.yawUp -= this.yawUp % 22.5f;
            }
            return true;
        }
        if (this.down) {
            this.yawDown = Mth.m_14177_((float)(this.yawDown + angle));
            if (constrainAngle) {
                this.yawDown -= this.yawDown % 22.5f;
            }
            return true;
        }
        return false;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return super.getCapability(cap, side);
    }

    @Override
    public void openScreen(Level level, BlockPos pos, Player player) {
        SignPostGui.open(this);
    }
}

