/*
 * Decompiled with CFR 0.152.
 */
package com.zainjx.the_wild_update.custom.utils;

import com.zainjx.the_wild_update.entity.custom.WardenEntity;
import com.zainjx.the_wild_update.registry.RegistryDeepdarkBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SculkActivator {
    public static List<BlockPos> positions = new ArrayList<BlockPos>();
    public static List<Integer> delay = new ArrayList<Integer>();
    public static List<Integer> wait = new ArrayList<Integer>();
    public static List<ServerLevel> worlds = new ArrayList<ServerLevel>();
    private static final int RADIUS = 11;
    public static final Block SENSOR = (Block)RegistryDeepdarkBlocks.SCULK_CATALYST.get();
    private static final TagKey<Block> WOOL = BlockTags.f_13089_;

    public static void SculkTick() {
        int i = 0;
        while (i < positions.size()) {
            ServerLevel world = worlds.get(i);
            if (delay.get(i) == wait.get(i)) {
                BlockPos pos = positions.get(i);
                BlockState state = world.m_8055_(pos);
                if (state.m_60734_().equals(SENSOR)) {
                    // empty if block
                }
                delay.set(i, delay.get(i++) + 1);
                continue;
            }
            if (delay.get(i) > wait.get(i) + 40 + 50) {
                positions.remove(i);
                delay.remove(i);
                wait.remove(i);
                worlds.remove(i);
                continue;
            }
            delay.set(i, delay.get(i++) + 1);
        }
    }

    public static void CheckSensors(ServerLevel world, BlockPos pos) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        for (int xx = -11; xx <= 11; ++xx) {
            int xxs = xx * xx;
            for (int zz = -11; zz <= 11; ++zz) {
                int zzs = zz * zz;
                for (int yy = -11; yy <= 11; ++yy) {
                    int lifetime;
                    int distance = (int)Math.floor(Math.sqrt(xxs + zzs + yy * yy));
                    if (distance >= 11 || distance == 0) continue;
                    int finalX = x + xx;
                    int finalY = y + yy;
                    int finalZ = z + zz;
                    if (finalY < 0) continue;
                    BlockPos newPos = new BlockPos(finalX, finalY, finalZ);
                    BlockState state = world.m_8055_(newPos);
                    BlockPos wardenPos = WardenEntity.getOnPosition();
                    if (wardenPos == null || finalX != wardenPos.m_123341_() || finalY != wardenPos.m_123342_() || finalZ != wardenPos.m_123343_()) continue;
                    double hyp = Math.sqrt(xxs + zzs);
                    double angleA = Math.atan2(zz, xx);
                    double sinA = Math.sin(angleA);
                    double cosA = Math.cos(angleA);
                    double angleB = Math.atan2(yy, hyp);
                    double sinB = Math.sin(angleB);
                    double cosB = Math.cos(angleB);
                    boolean woolFound = false;
                    int lastX = 0;
                    int lastY = 0;
                    int lastZ = 0;
                    for (double traveled = 0.0; traveled <= (double)distance; traveled += 0.1) {
                        int woolX = x + (int)(traveled * cosB * cosA);
                        int woolY = y + (int)(traveled * sinB);
                        int woolZ = z + (int)(traveled * cosB * sinA);
                        if (woolX == x && woolY == y && woolZ == z || woolX == lastX && woolY == lastY && woolZ == lastZ) continue;
                        lastX = woolX;
                        lastY = woolY;
                        lastZ = woolZ;
                        Set myTags = world.m_8055_(new BlockPos(woolX, woolY, woolZ)).m_204343_().collect(Collectors.toSet());
                        if (!myTags.contains(WOOL)) continue;
                        woolFound = true;
                        break;
                    }
                    if (woolFound) continue;
                    boolean found = false;
                    for (lifetime = 0; lifetime < positions.size(); ++lifetime) {
                        BlockPos posCheck = positions.get(lifetime);
                        if (posCheck.m_123341_() != newPos.m_123341_() || posCheck.m_123342_() != newPos.m_123342_() || posCheck.m_123343_() != newPos.m_123343_()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    lifetime = distance * 4 - 1;
                    positions.add(newPos);
                    delay.add(0);
                    wait.add(lifetime);
                    worlds.add(world);
                    System.out.println("voil\u00c3\u00a0");
                    WardenEntity.goToPos(pos);
                    WardenEntity.playClick(wardenPos, (Level)world);
                }
            }
        }
    }
}

