/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.screen;

import io.github.kosmx.emotes.common.tools.MathHelper;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.executor.dataTypes.InputKey;
import io.github.kosmx.emotes.executor.dataTypes.Text;
import io.github.kosmx.emotes.executor.dataTypes.other.EmotesTextFormatting;
import io.github.kosmx.emotes.executor.dataTypes.screen.IConfirmScreen;
import io.github.kosmx.emotes.executor.dataTypes.screen.widgets.IButton;
import io.github.kosmx.emotes.executor.dataTypes.screen.widgets.ITextInputWidget;
import io.github.kosmx.emotes.executor.dataTypes.screen.widgets.IWidget;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.MainClientInit;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.config.ClientSerializer;
import io.github.kosmx.emotes.main.screen.AbstractScreenLogic;
import io.github.kosmx.emotes.main.screen.IScreenSlave;
import io.github.kosmx.emotes.main.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.main.screen.widget.IChooseWheel;
import io.github.kosmx.emotes.main.screen.widget.IEmoteListWidgetHelper;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class EmoteMenu<MATRIX, SCREEN, WIDGET>
extends AbstractScreenLogic<MATRIX, SCREEN> {
    protected int activeKeyTime = 0;
    private IEmoteListWidgetHelper<MATRIX, WIDGET> emoteList;
    private FastChooseWidget fastMenu;
    private static final Text unboundText = EmoteInstance.instance.getDefaults().getUnknownKey().getLocalizedText();
    private IButton setKeyButton;
    public boolean save = false;
    public boolean warn = false;
    private ITextInputWidget<MATRIX, ITextInputWidget> searchBox;
    private List<PositionedText> texts = new ArrayList<PositionedText>();
    private IButton resetKey;
    private Text resetOneText = EmoteInstance.instance.getDefaults().newTranslationText("controls.reset");
    private Text resetAllText = EmoteInstance.instance.getDefaults().newTranslationText("controls.resetAll");
    private boolean resetOnlySelected;
    private int keyBoundEmotes = -1;
    private ChangeListener watcher = null;

    public EmoteMenu(IScreenSlave screen) {
        super(screen);
    }

    @Override
    public void emotes_initScreen() {
        block3: {
            if (this.warn && ((Boolean)((ClientConfig)EmoteInstance.config).enableQuark.get()).booleanValue()) {
                this.warn = false;
                IConfirmScreen csr = this.createConfigScreen(bool -> {
                    ((ClientConfig)EmoteInstance.config).enableQuark.set(bool);
                    this.screen.openThisScreen();
                }, EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.quark"), EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.quark2"));
                EmoteInstance.instance.getClientMethods().openScreen(csr);
                csr.setTimeout(56);
            }
            this.texts = new ArrayList<PositionedText>();
            MainClientInit.loadEmotes();
            try {
                this.watcher = new ChangeListener(EmoteInstance.instance.getExternalEmoteDir().toPath());
            }
            catch (IOException e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, "can't watch emotes dir for changes: " + e.getMessage());
                if (!((Boolean)EmoteInstance.config.showDebug.get()).booleanValue()) break block3;
                e.printStackTrace();
            }
        }
        this.searchBox = this.newTextInputWidget(this.screen.getWidth() / 2 - (int)((double)this.screen.getWidth() / 2.2 - 16.0) - 12, 12, (int)((double)this.screen.getWidth() / 2.2 - 16.0), 20, EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.search"));
        this.searchBox.setInputListener(string -> this.emoteList.filter(string::toLowerCase));
        this.screen.addToChildren(this.searchBox);
        this.screen.addToButtons(this.newButton(this.screen.getWidth() / 2 - 154, this.screen.getHeight() - 30, 150, 20, EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.openFolder"), buttonWidget -> this.openExternalEmotesDir()));
        this.emoteList = this.newEmoteList((int)((double)this.screen.getWidth() / 2.2 - 16.0), this.screen.getHeight());
        this.emoteList.emotesSetLeftPos(this.screen.getWidth() / 2 - (int)((double)this.screen.getWidth() / 2.2 - 16.0) - 12);
        this.screen.addToChildren(this.emoteList);
        int x = Math.min(this.screen.getWidth() / 4, (int)((double)this.screen.getHeight() / 2.5));
        this.fastMenu = this.newFastChooseWidghet(this.screen.getWidth() / 2 + 2, this.screen.getHeight() / 2 - 8, x - 7);
        this.screen.addToChildren(this.fastMenu);
        this.screen.addToButtons(this.newButton(this.screen.getWidth() - 100, 4, 96, 20, EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.options.options"), button -> this.openClothConfigScreen()));
        this.screen.addToButtons(this.newButton(this.screen.getWidth() - 200, 4, 96, 20, EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.options.export"), button -> this.openExportMenuScreen()));
        this.screen.addToButtons(this.newButton(this.screen.getWidth() / 2 + 10, this.screen.getHeight() - 30, 96, 20, EmoteInstance.instance.getDefaults().defaultTextsDone(), button -> this.screen.openParent()));
        this.setKeyButton = this.newButton(this.screen.getWidth() / 2 + 6, 60, 96, 20, unboundText, button -> this.activateKey());
        this.screen.addToButtons(this.setKeyButton);
        this.resetKey = this.newButton(this.screen.getWidth() / 2 + 124, 60, 96, 20, EmoteInstance.instance.getDefaults().newTranslationText("controls.reset"), this::resetKeyAction);
        this.screen.addToButtons(this.resetKey);
        this.emoteList.setEmotes(EmoteHolder.list, true);
        this.screen.setInitialFocus(this.searchBox);
        this.texts.add(new PositionedText(EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.options.keybind"), this.screen.getWidth() / 2 + 115, 40));
        this.texts.add(new PositionedText(EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.options.fastmenu"), this.screen.getWidth() / 2 + 10 + x / 2, this.screen.getHeight() / 2 - 54));
        this.texts.add(new PositionedText(EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.options.fastmenu2"), this.screen.getWidth() / 2 + 10 + x / 2, this.screen.getHeight() / 2 - 40));
        this.texts.add(new PositionedText(EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.options.fastmenu3"), this.screen.getWidth() / 2 + 10 + x / 2, this.screen.getHeight() / 2 - 26));
        this.screen.addButtonsToChildren();
    }

    protected abstract FastChooseWidget newFastChooseWidghet(int var1, int var2, int var3);

    public abstract void openClothConfigScreen();

    public abstract void openExportMenuScreen();

    private void activateKey() {
        if (this.emoteList.getSelectedEntry() != null) {
            this.setFocusedElement(this.setKeyButton);
            this.activeKeyTime = 200;
        }
    }

    public void setFocusedElement(@Nullable IWidget focused) {
        if (this.activeKeyTime == 0) {
            this.screen.setFocused(focused);
        }
    }

    private void resetKeyAction(IButton button) {
        if (this.resetOnlySelected) {
            if (this.emoteList.getSelectedEntry() == null) {
                return;
            }
            ((ClientConfig)EmoteInstance.config).emoteKeyMap.removeL(this.emoteList.getSelectedEntry().getEmote().getUuid());
            this.keyBoundEmotes = -1;
            this.save = true;
        } else {
            EmoteInstance.instance.getClientMethods().openScreen(this.createConfigScreen(aBoolean -> {
                if (aBoolean.booleanValue()) {
                    ((ClientConfig)EmoteInstance.config).emoteKeyMap.clear();
                    this.saveConfig();
                    this.keyBoundEmotes = -1;
                }
                this.screen.openThisScreen();
            }, EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.resetAllKeys.title"), EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.resetAllKeys.message").append(" (" + this.keyBoundEmotes + ")")));
        }
    }

    @Override
    public void emotes_tickScreen() {
        if (this.activeKeyTime == 1) {
            this.setFocusedElement(null);
        }
        if (this.activeKeyTime != 0) {
            --this.activeKeyTime;
        }
        if (this.watcher != null && this.watcher.isChanged()) {
            this.reload();
        }
    }

    @Override
    public boolean emotes_onMouseClicked(double mouseX, double mouseY, int button) {
        if (this.activeKeyTime != 0 && this.emoteList.getSelectedEntry() != null) {
            return this.setKey(EmoteInstance.instance.getDefaults().getMouseKeyFromCode(button));
        }
        return false;
    }

    private void countEmotesWithKeyBind() {
        this.keyBoundEmotes = ((ClientConfig)EmoteInstance.config).emoteKeyMap.size();
    }

    @Override
    public void emotes_renderScreen(MATRIX matrices, int mouseX, int mouseY, float delta) {
        this.screen.emotesRenderBackgroundTexture(0);
        if (this.emoteList.getSelectedEntry() == null) {
            this.setKeyButton.setActive(false);
            this.resetOnlySelected = false;
        } else {
            this.setKeyButton.setActive(true);
            this.resetOnlySelected = ((ClientConfig)EmoteInstance.config).emoteKeyMap.containsL(this.emoteList.getSelectedEntry().getEmote().getUuid());
        }
        if (this.resetOnlySelected) {
            this.resetKey.setActive(true);
            this.resetKey.setMessage(this.resetOneText);
        } else {
            if (this.keyBoundEmotes < 0) {
                this.countEmotesWithKeyBind();
            }
            if (this.keyBoundEmotes > 0) {
                this.resetKey.setActive(true);
                this.resetKey.setMessage(this.resetAllText.copyIt().append(" (" + this.keyBoundEmotes + ")"));
            } else {
                this.resetKey.setActive(false);
                this.resetKey.setMessage(this.resetOneText);
            }
        }
        for (PositionedText str : this.texts) {
            str.render(matrices);
        }
        this.emoteList.renderThis(matrices, mouseX, mouseY, delta);
        this.searchBox.render(matrices, mouseX, mouseY, delta);
        this.fastMenu.render(matrices, mouseX, mouseY, delta);
        this.updateKeyText();
    }

    private boolean setKey(InputKey key) {
        boolean bl = false;
        if (this.emoteList.getSelectedEntry() != null) {
            bl = true;
            if (!this.applyKey(false, this.emoteList.getSelectedEntry().getEmote(), key)) {
                EmoteInstance.instance.getClientMethods().openScreen(this.createConfigScreen(aBoolean -> this.confirmReturn((boolean)aBoolean, this.emoteList.getSelectedEntry().getEmote(), key), EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.sure"), EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.sure2")));
            }
        }
        return bl;
    }

    private void confirmReturn(boolean choice, EmoteHolder emoteHolder, InputKey key) {
        if (choice) {
            this.applyKey(true, emoteHolder, key);
            this.saveConfig();
        }
        this.screen.openThisScreen();
    }

    private boolean applyKey(boolean force, EmoteHolder emote, InputKey key) {
        boolean bl = true;
        for (EmoteHolder emoteHolder : EmoteHolder.list) {
            if (key.equals(EmoteInstance.instance.getDefaults().getUnknownKey()) || !EmoteMenu.getKey(emoteHolder.getUuid()).equals(key)) continue;
            bl = false;
            if (!force) continue;
            ((ClientConfig)EmoteInstance.config).emoteKeyMap.removeL(emoteHolder.getUuid());
        }
        if (bl || force) {
            ((ClientConfig)EmoteInstance.config).emoteKeyMap.put(emote.getUuid(), key);
            this.save = true;
            this.keyBoundEmotes = -1;
        }
        this.activeKeyTime = 0;
        return bl;
    }

    @Nonnull
    public static InputKey getKey(UUID emoteID) {
        InputKey key = ((ClientConfig)EmoteInstance.config).emoteKeyMap.getR(emoteID);
        if (key == null) {
            return EmoteInstance.instance.getDefaults().getUnknownKey();
        }
        return key;
    }

    @Override
    public void emotes_onRemove() {
        if (this.save) {
            this.saveConfig();
        }
    }

    private void saveConfig() {
        ClientSerializer.saveConfig();
    }

    private void reload() {
        if (this.save) {
            this.saveConfig();
        }
        MainClientInit.loadEmotes();
        this.emoteList.setEmotes(EmoteHolder.list, true);
    }

    private void updateKeyText() {
        if (this.emoteList.getSelectedEntry() != null) {
            Text message = EmoteMenu.getKey(this.emoteList.getSelectedEntry().getEmote().getUuid()).getLocalizedText();
            if (this.activeKeyTime != 0) {
                message = EmoteInstance.instance.getDefaults().textFromString("> ").append(message).formatted(EmotesTextFormatting.YELLOW).append(" <").formatted(EmotesTextFormatting.YELLOW);
            }
            this.setKeyButton.setMessage(message);
        }
    }

    @Override
    public boolean emotes_onKeyPressed(int keyCode, int scanCode, int mod) {
        if (this.emoteList.getSelectedEntry() != null && this.activeKeyTime != 0) {
            if (keyCode == 256) {
                return this.setKey(EmoteInstance.instance.getDefaults().getUnknownKey());
            }
            return this.setKey(EmoteInstance.instance.getDefaults().getKeyFromCode(keyCode, scanCode));
        }
        return false;
    }

    @Override
    public void emotes_filesDropped(List<Path> paths) {
        this.addEmotes(paths);
        List folders = paths.stream().filter(path -> path.toFile().isDirectory()).collect(Collectors.toList());
        paths = new ArrayList<Path>();
        for (Path folder : folders) {
            ArrayList<Path> collect = new ArrayList<Path>();
            Arrays.stream(Objects.requireNonNull(folder.toFile().listFiles((dir, name) -> name.endsWith(".json") || name.endsWith(".png")))).forEach(file -> collect.add(file.toPath()));
            this.addEmotes(collect);
        }
    }

    private void addEmotes(List<Path> emotes) {
        List newEmotes = emotes.stream().filter(path -> {
            if (path.toFile().isFile() && (path.toFile().getName().endsWith(".png") || path.toFile().getName().endsWith(".emote") && ((Boolean)((ClientConfig)EmoteInstance.config).enableQuark.get()).booleanValue())) {
                return true;
            }
            try {
                return UniversalEmoteSerializer.readData(Files.newInputStream(path, new OpenOption[0]), path.getFileName().toString()).size() != 0;
            }
            catch (Exception e) {
                return false;
            }
        }).collect(Collectors.toList());
        Path emotesDir = EmoteInstance.instance.getExternalEmoteDir().toPath();
        for (Path path2 : newEmotes) {
            try {
                Files.copy(path2, emotesDir.resolve(path2.getFileName()), new CopyOption[0]);
            }
            catch (IOException e) {
                if (e instanceof FileAlreadyExistsException) {
                    EmoteInstance.instance.getLogger().log(Level.INFO, path2.getFileName() + " is already in the emotes directory", true);
                    continue;
                }
                EmoteInstance.instance.getLogger().log(Level.FINEST, "Unknown error while copying " + path2.getFileName() + ": " + e.getMessage(), true);
                if (!((Boolean)EmoteInstance.config.showDebug.get()).booleanValue()) continue;
                e.printStackTrace();
            }
        }
    }

    protected abstract IEmoteListWidgetHelper<MATRIX, WIDGET> newEmoteList(int var1, int var2);

    private static class ChangeListener
    implements AutoCloseable {
        private final WatchService watcher;
        private final Path path;

        ChangeListener(Path path) throws IOException {
            this.watcher = path.getFileSystem().newWatchService();
            this.path = path;
            this.path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }

        boolean isChanged() {
            boolean bl = false;
            WatchKey key = this.watcher.poll();
            if (key != null) {
                bl = key.pollEvents().size() != 0;
                key.reset();
            }
            return bl;
        }

        @Override
        public void close() throws Exception {
            this.watcher.close();
        }
    }

    protected abstract class FastChooseWidget
    extends AbstractFastChooseWidget<MATRIX, WIDGET> {
        public FastChooseWidget(int x, int y, int size) {
            super(x, y, size);
        }

        @Override
        protected boolean isValidClickButton(int button) {
            return (button == 0 || button == 1) && EmoteMenu.this.activeKeyTime == 0;
        }

        @Override
        protected boolean EmotesOnClick(IChooseWheel.IChooseElement element, int button) {
            if (EmoteMenu.this.activeKeyTime != 0) {
                return false;
            }
            if (button == 1) {
                element.clearEmote();
                EmoteMenu.this.save = true;
                return true;
            }
            if (EmoteMenu.this.emoteList.getSelectedEntry() != null) {
                element.setEmote(EmoteMenu.this.emoteList.getSelectedEntry().getEmote());
                EmoteMenu.this.save = true;
                return true;
            }
            return false;
        }

        @Override
        protected boolean doHoverPart(IChooseWheel.IChooseElement part) {
            return EmoteMenu.this.activeKeyTime == 0;
        }

        @Override
        protected boolean doesShowInvalid() {
            return true;
        }
    }

    private class PositionedText {
        private final Text str;
        private final int x;
        private final int y;

        private PositionedText(Text str, int x, int y) {
            this.str = str;
            this.x = x;
            this.y = y;
        }

        private void render(MATRIX matrixStack) {
            EmoteMenu.this.drawCenteredText(matrixStack, this.str, this.x, this.y, MathHelper.colorHelper(255, 255, 255, 255));
        }
    }
}

