/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.kosmx.emotes.common.emote.EmoteData;
import io.github.kosmx.emotes.common.emote.EmoteFormat;
import io.github.kosmx.emotes.common.tools.Ease;
import io.github.kosmx.emotes.common.tools.Easing;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.executor.dataTypes.Text;
import io.github.kosmx.emotes.executor.dataTypes.other.EmotesTextFormatting;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class GeckoLibSerializer {
    public static List<EmoteData> serialize(JsonObject node) {
        if (!node.get("format_version").getAsString().equals("1.8.0")) {
            EmoteInstance.instance.getLogger().log(Level.INFO, "Gecko lib format what is this version?");
        }
        return GeckoLibSerializer.readAnimations(node.get("animations").getAsJsonObject());
    }

    private static List<EmoteData> readAnimations(JsonObject jsonEmotes) {
        ArrayList<EmoteData> emotes = new ArrayList<EmoteData>();
        jsonEmotes.entrySet().forEach(stringJsonElementEntry -> {
            EmoteData.EmoteBuilder builder = new EmoteData.EmoteBuilder(EmoteFormat.JSON_MC_ANIM);
            Text name = EmoteInstance.instance.getDefaults().textFromString((String)stringJsonElementEntry.getKey()).formatted(EmotesTextFormatting.WHITE);
            JsonObject node = ((JsonElement)stringJsonElementEntry.getValue()).getAsJsonObject();
            builder.endTick = (int)Math.ceil(node.get("animation_length").getAsFloat() * 20.0f);
            if (node.has("loop")) {
                boolean bl = builder.isLooped = node.get("loop").getAsJsonPrimitive().isBoolean() && node.get("loop").getAsBoolean();
                if (!builder.isLooped && node.get("loop").getAsJsonPrimitive().isString() && node.get("loop").getAsString().equals("hold_on_last_frame")) {
                    builder.isLooped = true;
                    builder.returnTick = builder.endTick;
                }
            }
            builder.fullyEnableParts();
            builder.optimizeEmote();
            builder.name = name.toJsonTree().toString();
            builder.description = EmoteInstance.instance.getDefaults().textFromString("").formatted(EmotesTextFormatting.YELLOW).toString();
            EmoteData emoteData = builder.build();
            GeckoLibSerializer.keyframeSerializer(emoteData, node.get("bones").getAsJsonObject());
            emotes.add(emoteData);
        });
        return emotes;
    }

    private static void keyframeSerializer(EmoteData emoteData, JsonObject node) {
        if (node.has("head")) {
            GeckoLibSerializer.readBone(emoteData.head, node.get("head").getAsJsonObject(), emoteData);
        }
        if (node.has("body")) {
            GeckoLibSerializer.readBone(emoteData.body, node.get("body").getAsJsonObject(), emoteData);
        }
        if (node.has("right_arm")) {
            GeckoLibSerializer.readBone(emoteData.rightArm, node.get("right_arm").getAsJsonObject(), emoteData);
        } else if (node.has("rightArm")) {
            GeckoLibSerializer.readBone(emoteData.rightArm, node.get("rightArm").getAsJsonObject(), emoteData);
        }
        if (node.has("left_arm")) {
            GeckoLibSerializer.readBone(emoteData.leftArm, node.get("left_arm").getAsJsonObject(), emoteData);
        } else if (node.has("leftArm")) {
            GeckoLibSerializer.readBone(emoteData.leftArm, node.get("leftArm").getAsJsonObject(), emoteData);
        }
        if (node.has("right_leg")) {
            GeckoLibSerializer.readBone(emoteData.rightLeg, node.get("right_leg").getAsJsonObject(), emoteData);
        } else if (node.has("rightLeg")) {
            GeckoLibSerializer.readBone(emoteData.rightLeg, node.get("rightLeg").getAsJsonObject(), emoteData);
        }
        if (node.has("left_leg")) {
            GeckoLibSerializer.readBone(emoteData.leftLeg, node.get("left_leg").getAsJsonObject(), emoteData);
        } else if (node.has("leftLeg")) {
            GeckoLibSerializer.readBone(emoteData.leftLeg, node.get("leftLeg").getAsJsonObject(), emoteData);
        }
    }

    private static void readBone(EmoteData.StateCollection stateCollection, JsonObject node, EmoteData emoteData) {
        if (node.has("rotation")) {
            JsonElement jsonRotation = node.get("rotation");
            if (jsonRotation.isJsonArray()) {
                GeckoLibSerializer.readCollection(GeckoLibSerializer.getRots(stateCollection), 0, Ease.LINEAR, jsonRotation.getAsJsonArray(), emoteData);
            } else {
                jsonRotation.getAsJsonObject().entrySet().forEach(entry -> {
                    if (((String)entry.getKey()).equals("vector")) {
                        GeckoLibSerializer.readCollection(GeckoLibSerializer.getRots(stateCollection), 0, Ease.LINEAR, ((JsonElement)entry.getValue()).getAsJsonArray(), emoteData);
                    } else {
                        int tick = (int)(Float.parseFloat((String)entry.getKey()) * 20.0f);
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            GeckoLibSerializer.readCollection(GeckoLibSerializer.getRots(stateCollection), tick, Ease.CONSTANT, ((JsonElement)entry.getValue()).getAsJsonArray(), emoteData);
                        } else {
                            Ease ease = Ease.LINEAR;
                            JsonObject currentNode = ((JsonElement)entry.getValue()).getAsJsonObject();
                            if (currentNode.has("lerp_mode")) {
                                String lerp = currentNode.get("lerp_mode").getAsString();
                                Ease ease2 = ease = lerp.equals("catmullrom") ? Ease.INOUTSINE : Easing.easeFromString(lerp);
                            }
                            if (currentNode.has("easing")) {
                                ease = Easing.easeFromString(currentNode.get("easing").getAsString());
                            }
                            if (currentNode.has("pre")) {
                                GeckoLibSerializer.readCollection(GeckoLibSerializer.getRots(stateCollection), tick, ease, currentNode.get("pre").getAsJsonArray(), emoteData);
                            }
                            if (currentNode.has("vector")) {
                                GeckoLibSerializer.readCollection(GeckoLibSerializer.getRots(stateCollection), tick, ease, currentNode.get("vector").getAsJsonArray(), emoteData);
                            }
                            if (currentNode.has("post")) {
                                GeckoLibSerializer.readCollection(GeckoLibSerializer.getRots(stateCollection), tick, ease, currentNode.get("post").getAsJsonArray(), emoteData);
                            }
                        }
                    }
                });
            }
        }
        if (node.has("position")) {
            JsonElement jsonPosition = node.get("position");
            if (jsonPosition.isJsonArray()) {
                GeckoLibSerializer.readCollection(GeckoLibSerializer.getOffs(stateCollection), 0, Ease.LINEAR, jsonPosition.getAsJsonArray(), emoteData);
            } else {
                jsonPosition.getAsJsonObject().entrySet().forEach(entry -> {
                    if (((String)entry.getKey()).equals("vector")) {
                        GeckoLibSerializer.readCollection(GeckoLibSerializer.getOffs(stateCollection), 0, Ease.LINEAR, ((JsonElement)entry.getValue()).getAsJsonArray(), emoteData);
                    } else {
                        int tick = (int)(Float.parseFloat((String)entry.getKey()) * 20.0f);
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            GeckoLibSerializer.readCollection(GeckoLibSerializer.getOffs(stateCollection), tick, Ease.LINEAR, ((JsonElement)entry.getValue()).getAsJsonArray(), emoteData);
                        } else {
                            Ease ease = Ease.LINEAR;
                            JsonObject currentNode = ((JsonElement)entry.getValue()).getAsJsonObject();
                            if (currentNode.has("lerp_mode")) {
                                String lerp = currentNode.get("lerp_mode").getAsString();
                                Ease ease2 = ease = lerp.equals("catmullrom") ? Ease.INOUTSINE : Easing.easeFromString(lerp);
                            }
                            if (currentNode.has("easing")) {
                                ease = Easing.easeFromString(currentNode.get("easing").getAsString());
                            }
                            if (currentNode.has("pre")) {
                                GeckoLibSerializer.readCollection(GeckoLibSerializer.getOffs(stateCollection), tick, ease, currentNode.get("pre").getAsJsonArray(), emoteData);
                            }
                            if (currentNode.has("vector")) {
                                GeckoLibSerializer.readCollection(GeckoLibSerializer.getOffs(stateCollection), tick, ease, currentNode.get("vector").getAsJsonArray(), emoteData);
                            }
                            if (currentNode.has("post")) {
                                GeckoLibSerializer.readCollection(GeckoLibSerializer.getOffs(stateCollection), tick, ease, currentNode.get("post").getAsJsonArray(), emoteData);
                            }
                        }
                    }
                });
            }
        }
    }

    private static void readCollection(EmoteData.StateCollection.State[] a, int tick, Ease ease, JsonArray array, EmoteData emoteData) {
        if (a.length != 3) {
            throw new ArrayStoreException("wrong array length");
        }
        for (int i = 0; i < 3; ++i) {
            float value = array.get(i).getAsFloat();
            if (a[0] == emoteData.body.x) {
                value /= 16.0f;
            } else if (a[0] == emoteData.body.pitch) {
                value = -value;
            }
            a[i].addKeyFrame(tick, value += a[i].defaultValue, ease, 0, true);
        }
    }

    private static EmoteData.StateCollection.State[] getRots(EmoteData.StateCollection stateCollection) {
        return new EmoteData.StateCollection.State[]{stateCollection.pitch, stateCollection.yaw, stateCollection.roll};
    }

    private static EmoteData.StateCollection.State[] getOffs(EmoteData.StateCollection stateCollection) {
        return new EmoteData.StateCollection.State[]{stateCollection.x, stateCollection.y, stateCollection.z};
    }
}

