/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.pavocado.exoticbirds.ExoticBirdsMod;
import net.pavocado.exoticbirds.capabilities.BirdTracking;
import net.pavocado.exoticbirds.capabilities.BirdTrackingProvider;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;
import net.pavocado.exoticbirds.entity.AbstractPhoenixEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsPlacedFeatures;
import net.pavocado.exoticbirds.item.BirdBookItem;

@Mod.EventBusSubscriber(modid="exoticbirds", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventSubscriber {
    @SubscribeEvent
    public static void onRegisterCaps(RegisterCapabilitiesEvent event) {
        event.register(BirdTracking.class);
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            BirdTrackingProvider trackingProvider = new BirdTrackingProvider();
            event.addCapability(new ResourceLocation("exoticbirds", "bird_tracking"), (ICapabilityProvider)trackingProvider);
        }
    }

    @SubscribeEvent
    public static void onMountEntity(EntityMountEvent event) {
        if (!event.getWorldObj().m_5776_() && event.isDismounting() && event.getEntityBeingMounted() instanceof AbstractPhoenixEntity && event.getEntityBeingMounted().m_6084_() && event.getEntityMounting().m_6084_() && !event.getEntityBeingMounted().m_20096_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEggImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ThrownEgg && !entity.f_19853_.m_5776_()) {
            Random rand = entity.f_19853_.f_46441_;
            if (((Boolean)ExoticBirdsCommonConfig.allowCreateVanillaEggshell.get()).booleanValue() && rand.nextInt(3) == 0) {
                entity.m_19983_(new ItemStack((ItemLike)ExoticBirdsItems.EGGSHELL.get(), rand.nextInt(2) + 1));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        String biomeName = event.getName().toString();
        if (!((List)ExoticBirdsCommonConfig.blacklistedNestGenBiomes.get()).contains(biomeName) && (((List)ExoticBirdsCommonConfig.whitelistedNestGenBiomes.get()).contains(biomeName) || event.getCategory() == Biome.BiomeCategory.JUNGLE || event.getCategory() == Biome.BiomeCategory.SAVANNA || event.getCategory() == Biome.BiomeCategory.PLAINS || event.getCategory() == Biome.BiomeCategory.TAIGA || event.getCategory() == Biome.BiomeCategory.FOREST || event.getCategory() == Biome.BiomeCategory.SWAMP)) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, ExoticBirdsPlacedFeatures.NEST);
        }
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.BLUEJAY.get(), (Integer)ExoticBirdsCommonConfig.spawnRateBluejay.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinBluejay.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxBluejay.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesBluejay.get(), biome -> biome.getCategory() == Biome.BiomeCategory.FOREST && biome.getClimate().f_47680_ == Biome.Precipitation.RAIN);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.CARDINAL.get(), (Integer)ExoticBirdsCommonConfig.spawnRateCardinal.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinCardinal.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxCardinal.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesCardinal.get(), biome -> biome.getCategory() == Biome.BiomeCategory.FOREST && biome.getClimate().f_47680_ == Biome.Precipitation.RAIN);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.ROBIN.get(), (Integer)ExoticBirdsCommonConfig.spawnRateRobin.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinRobin.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxRobin.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesRobin.get(), biome -> (biome.getCategory() == Biome.BiomeCategory.FOREST || biome.getCategory() == Biome.BiomeCategory.TAIGA) && biome.getClimate().f_47681_ < 1.0f);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.FLAMINGO.get(), (Integer)ExoticBirdsCommonConfig.spawnRateFlamingo.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinFlamingo.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxFlamingo.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesFlamingo.get(), biome -> (biome.getCategory() == Biome.BiomeCategory.SWAMP || biome.getCategory() == Biome.BiomeCategory.BEACH) && biome.getClimate().f_47680_ != Biome.Precipitation.SNOW);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.LYREBIRD.get(), (Integer)ExoticBirdsCommonConfig.spawnRateLyrebird.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinLyrebird.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxLyrebird.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesLyrebird.get(), biome -> (biome.getCategory() == Biome.BiomeCategory.FOREST || biome.getCategory() == Biome.BiomeCategory.JUNGLE) && biome.getClimate().f_47681_ >= 0.5f);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.ROADRUNNER.get(), (Integer)ExoticBirdsCommonConfig.spawnRateRoadrunner.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinRoadrunner.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxRoadrunner.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesRoadrunner.get(), biome -> biome.getCategory() == Biome.BiomeCategory.DESERT || biome.getCategory() == Biome.BiomeCategory.MESA);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.OSTRICH.get(), (Integer)ExoticBirdsCommonConfig.spawnRateOstrich.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinOstrich.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxOstrich.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesOstrich.get(), biome -> biome.getCategory() == Biome.BiomeCategory.DESERT || biome.getCategory() == Biome.BiomeCategory.SAVANNA);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.HUMMINGBIRD.get(), (Integer)ExoticBirdsCommonConfig.spawnRateHummingbird.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinHummingbird.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxHummingbird.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesHummingbird.get(), biome -> biome.getCategory() == Biome.BiomeCategory.SAVANNA || biome.getCategory() != Biome.BiomeCategory.MUSHROOM && biome.getClimate().f_47681_ >= 0.7f && biome.getClimate().f_47681_ < 1.5f && biome.getClimate().f_47680_ == Biome.Precipitation.RAIN);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.PENGUIN.get(), (Integer)ExoticBirdsCommonConfig.spawnRatePenguin.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinPenguin.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxPenguin.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesPenguin.get(), biome -> biome.getClimate().f_47680_ == Biome.Precipitation.SNOW);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.KINGFISHER.get(), (Integer)ExoticBirdsCommonConfig.spawnRateKingfisher.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinKingfisher.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxKingfisher.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesKingfisher.get(), biome -> biome.getCategory() == Biome.BiomeCategory.RIVER && biome.getClimate().f_47680_ == Biome.Precipitation.RAIN);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.SWAN.get(), (Integer)ExoticBirdsCommonConfig.spawnRateSwan.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinSwan.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxSwan.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesSwan.get(), biome -> (biome.getCategory() == Biome.BiomeCategory.RIVER || biome.getCategory() == Biome.BiomeCategory.BEACH) && biome.getClimate().f_47680_ == Biome.Precipitation.RAIN);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.PEAFOWL.get(), (Integer)ExoticBirdsCommonConfig.spawnRatePeafowl.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinPeafowl.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxPeafowl.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesPeafowl.get(), biome -> (biome.getCategory() == Biome.BiomeCategory.PLAINS || biome.getCategory() == Biome.BiomeCategory.FOREST) && biome.getClimate().f_47681_ >= 0.5f && biome.getClimate().f_47681_ < 2.0f);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.MAGPIE.get(), (Integer)ExoticBirdsCommonConfig.spawnRateMagpie.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinMagpie.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxMagpie.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesMagpie.get(), biome -> biome.getCategory() == Biome.BiomeCategory.FOREST && biome.getClimate().f_47681_ < 1.0f);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.OWL.get(), (Integer)ExoticBirdsCommonConfig.spawnRateOwl.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinOwl.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxOwl.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesOwl.get(), biome -> (biome.getCategory() == Biome.BiomeCategory.FOREST || biome.getCategory() == Biome.BiomeCategory.TAIGA) && biome.getClimate().f_47681_ < 0.7f);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.BOOBY.get(), (Integer)ExoticBirdsCommonConfig.spawnRateBooby.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinBooby.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxBooby.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesBooby.get(), biome -> biome.getCategory() == Biome.BiomeCategory.BEACH && biome.getClimate().f_47681_ >= 0.5f);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.BUDGERIGAR.get(), (Integer)ExoticBirdsCommonConfig.spawnRateBudgerigar.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinBudgerigar.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxBudgerigar.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesBudgerigar.get(), biome -> biome.getCategory() == Biome.BiomeCategory.SAVANNA || biome.getCategory() == Biome.BiomeCategory.JUNGLE);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.CASSOWARY.get(), (Integer)ExoticBirdsCommonConfig.spawnRateCassowary.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinCassowary.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxCassowary.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesCassowary.get(), biome -> (biome.getCategory() == Biome.BiomeCategory.PLAINS || biome.getCategory() == Biome.BiomeCategory.FOREST) && biome.getClimate().f_47681_ >= 0.7f);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.COCKATOO.get(), (Integer)ExoticBirdsCommonConfig.spawnRateCockatoo.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinCockatoo.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxCockatoo.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesCockatoo.get(), biome -> biome.getCategory() == Biome.BiomeCategory.SAVANNA || biome.getCategory() == Biome.BiomeCategory.JUNGLE);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.CRANE.get(), (Integer)ExoticBirdsCommonConfig.spawnRateCrane.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinCrane.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxCrane.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesCrane.get(), biome -> biome.getCategory() == Biome.BiomeCategory.SWAMP || biome.getCategory() == Biome.BiomeCategory.BEACH || biome.getCategory() == Biome.BiomeCategory.RIVER);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.DUCK.get(), (Integer)ExoticBirdsCommonConfig.spawnRateDuck.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinDuck.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxDuck.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesDuck.get(), biome -> biome.getCategory() == Biome.BiomeCategory.RIVER || biome.getCategory() == Biome.BiomeCategory.SWAMP);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.GOULDIANFINCH.get(), (Integer)ExoticBirdsCommonConfig.spawnRateGouldianfinch.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinGouldianfinch.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxGouldianfinch.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesGouldianfinch.get(), biome -> biome.getCategory() == Biome.BiomeCategory.JUNGLE || biome.getCategory() == Biome.BiomeCategory.SAVANNA || biome.getCategory() == Biome.BiomeCategory.MESA);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.GULL.get(), (Integer)ExoticBirdsCommonConfig.spawnRateGull.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinGull.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxGull.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesGull.get(), biome -> biome.getCategory() == Biome.BiomeCategory.BEACH);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.HERON.get(), (Integer)ExoticBirdsCommonConfig.spawnRateHeron.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinHeron.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxHeron.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesHeron.get(), biome -> biome.getCategory() == Biome.BiomeCategory.SWAMP || biome.getCategory() == Biome.BiomeCategory.BEACH || biome.getCategory() == Biome.BiomeCategory.RIVER);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.KIWI.get(), (Integer)ExoticBirdsCommonConfig.spawnRateKiwi.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinKiwi.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxKiwi.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesKiwi.get(), biome -> biome.getCategory() == Biome.BiomeCategory.FOREST && biome.getClimate().f_47681_ >= 0.7f);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.KOOKABURRA.get(), (Integer)ExoticBirdsCommonConfig.spawnRateKookaburra.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinKookaburra.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxKookaburra.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesKookaburra.get(), biome -> biome.getCategory() == Biome.BiomeCategory.SAVANNA);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.MACAW.get(), (Integer)ExoticBirdsCommonConfig.spawnRateMacaw.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinMacaw.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxMacaw.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesMacaw.get(), biome -> biome.getCategory() == Biome.BiomeCategory.JUNGLE);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.PELICAN.get(), (Integer)ExoticBirdsCommonConfig.spawnRatePelican.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinPelican.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxPelican.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesPelican.get(), biome -> (biome.getCategory() == Biome.BiomeCategory.RIVER || biome.getCategory() == Biome.BiomeCategory.BEACH) && biome.getClimate().f_47681_ >= 0.5f);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.PIGEON.get(), (Integer)ExoticBirdsCommonConfig.spawnRatePigeon.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinPigeon.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxPigeon.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesPigeon.get(), biome -> biome.getCategory() != Biome.BiomeCategory.OCEAN && biome.getClimate().f_47681_ >= 0.6f && biome.getClimate().f_47681_ <= 0.9f && biome.getClimate().f_47680_ != Biome.Precipitation.NONE);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.TOUCAN.get(), (Integer)ExoticBirdsCommonConfig.spawnRateToucan.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinToucan.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxToucan.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesToucan.get(), biome -> biome.getCategory() == Biome.BiomeCategory.JUNGLE);
        ForgeEventSubscriber.registerEntityWorldSpawn(event, (EntityType)ExoticBirdsEntities.WOODPECKER.get(), (Integer)ExoticBirdsCommonConfig.spawnRateWoodpecker.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMinWoodpecker.get(), (Integer)ExoticBirdsCommonConfig.spawnSizeMaxWoodpecker.get(), (List)ExoticBirdsCommonConfig.blacklistedBiomesWoodpecker.get(), biome -> biome.getCategory() == Biome.BiomeCategory.FOREST || biome.getCategory() == Biome.BiomeCategory.TAIGA);
    }

    @SubscribeEvent
    public static void checkSpawns(LivingSpawnEvent.CheckSpawn event) {
        Entity entity = event.getEntity();
        if (entity instanceof AbstractBirdEntity) {
            AbstractBirdEntity birdEntity = (AbstractBirdEntity)entity;
            String currentDimension = event.getEntity().f_19853_.m_6042_().m_63969_().toString();
            for (String dimensionType : (List)ExoticBirdsCommonConfig.blacklistedSpawningDimensions.get()) {
                if (!dimensionType.equals(currentDimension)) continue;
                event.setResult(Event.Result.DENY);
            }
            for (String dimensionType : birdEntity.getBlacklistedDimensions()) {
                if (!dimensionType.equals(currentDimension)) continue;
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        BirdBookItem.syncLoggedBirds(player);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        BirdBookItem.syncLoggedBirds(event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        BirdBookItem.syncLoggedBirds(event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getPlayer();
        if (event.isWasDeath() && player != null) {
            event.getOriginal().reviveCaps();
            if (BirdTrackingProvider.BIRD_TRACKING_CAPABILITY != null) {
                LazyOptional newStorage = player.getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY);
                LazyOptional oldStorage = event.getOriginal().getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY);
                if (newStorage.isPresent() && oldStorage.isPresent()) {
                    oldStorage.ifPresent(oldStats -> newStorage.ifPresent(newStats -> newStats.setAll(oldStats.getAll())));
                } else {
                    ExoticBirdsMod.LOGGER.warn("Bird tracking capability for " + player.m_5446_().getString() + " does not exist.");
                }
            }
        }
    }

    protected static void registerEntityWorldSpawn(BiomeLoadingEvent event, EntityType<?> entityType, int spawnRarity, int minSpawnSize, int maxSpawnSize, List<String> blacklistedBiomes, Predicate<BiomeLoadingEvent> biomePredicate) {
        if (biomePredicate.test(event) && spawnRarity > 0) {
            String biomeName = event.getName().toString();
            if (!((List)ExoticBirdsCommonConfig.blacklistedSpawningBiomes.get()).contains(biomeName) && !blacklistedBiomes.contains(biomeName)) {
                event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(entityType, spawnRarity, minSpawnSize, maxSpawnSize));
            }
        }
    }
}

