/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.block;

import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import net.pavocado.exoticbirds.blockentity.PhoenixEggBlockEntity;
import net.pavocado.exoticbirds.entity.AbstractPhoenixEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsBlockEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsPacketHandler;
import net.pavocado.exoticbirds.network.PacketLogPhoenixEgg;
import org.jetbrains.annotations.Nullable;

public class PhoenixEggBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private EntityType<? extends AbstractPhoenixEntity> phoenixType;

    public PhoenixEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_7417_(BlockState state, Direction p_56286_, BlockState p_56287_, LevelAccessor p_56288_, BlockPos p_56289_, BlockPos p_56290_) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_56288_.m_186469_(p_56289_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_56288_));
        }
        return super.m_7417_(state, p_56286_, p_56287_, p_56288_, p_56289_, p_56290_);
    }

    public VoxelShape m_5940_(BlockState p_52930_, BlockGetter p_52931_, BlockPos p_52932_, CollisionContext p_52933_) {
        return SHAPE;
    }

    public void initType(EntityType<? extends AbstractPhoenixEntity> birdType) {
        this.phoenixType = birdType;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PhoenixEggBlockEntity(pos, state, this.phoenixType);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof PhoenixEggBlockEntity) {
            PhoenixEggBlockEntity phoenixEgg = (PhoenixEggBlockEntity)blockentity;
            ExoticBirdsPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PacketLogPhoenixEgg(phoenixEgg.m_58899_(), phoenixEgg.hatchTime));
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return level.f_46443_ ? null : PhoenixEggBlock.m_152132_(entityType, (BlockEntityType)((BlockEntityType)ExoticBirdsBlockEntities.PHOENIX_EGG.get()), PhoenixEggBlockEntity::serverTick);
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random rand) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof PhoenixEggBlockEntity) {
            ParticleOptions particle = this.getParticles(((PhoenixEggBlockEntity)entity).getPhoenixType());
            level.m_7106_(particle, (double)pos.m_123341_() + (double)rand.nextFloat() * 1.0, (double)pos.m_123342_() + 0.15, (double)pos.m_123343_() + 1.0, 0.0, (double)rand.nextFloat() * 0.04, 0.0);
            level.m_7106_(particle, (double)pos.m_123341_() + (double)rand.nextFloat() * 1.0, (double)pos.m_123342_() + 0.15, (double)pos.m_123343_(), 0.0, (double)rand.nextFloat() * 0.04, 0.0);
            level.m_7106_(particle, (double)pos.m_123341_() + 1.0, (double)pos.m_123342_() + 0.15, (double)pos.m_123343_() + (double)rand.nextFloat() * 1.0, 0.0, (double)rand.nextFloat() * 0.04, 0.0);
            level.m_7106_(particle, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.15, (double)pos.m_123343_() + (double)rand.nextFloat() * 1.0, 0.0, (double)rand.nextFloat() * 0.04, 0.0);
        }
    }

    private ParticleOptions getParticles(EntityType<? extends AbstractPhoenixEntity> phoenixType) {
        if (phoenixType == ExoticBirdsEntities.NETHER_PHOENIX.get()) {
            return new DustColorTransitionOptions(new Vector3f(Vec3.m_82501_((int)329226)), DustParticleOptions.f_175788_, 1.5f);
        }
        if (phoenixType == ExoticBirdsEntities.ENDER_PHOENIX.get()) {
            return new DustColorTransitionOptions(new Vector3f(Vec3.m_82501_((int)329226)), new Vector3f(Vec3.m_82501_((int)11217601)), 1.5f);
        }
        if (phoenixType == ExoticBirdsEntities.SNOWY_PHOENIX.get()) {
            return new DustColorTransitionOptions(new Vector3f(Vec3.m_82501_((int)0xFFFFFF)), new Vector3f(Vec3.m_82501_((int)0x7CFFFF)), 1.5f);
        }
        if (phoenixType == ExoticBirdsEntities.DESERT_PHOENIX.get()) {
            return new DustParticleOptions(new Vector3f(Vec3.m_82501_((int)11306324)), 1.5f);
        }
        if (phoenixType == ExoticBirdsEntities.WATER_PHOENIX.get()) {
            return new DustParticleOptions(new Vector3f(Vec3.m_82501_((int)6527973)), 1.5f);
        }
        if (phoenixType == ExoticBirdsEntities.SKELETON_PHOENIX.get()) {
            return new DustColorTransitionOptions(new Vector3f(Vec3.m_82501_((int)12238766)), new Vector3f(Vec3.m_82501_((int)8829521)), 1.5f);
        }
        if (phoenixType == ExoticBirdsEntities.CLOUD_PHOENIX.get()) {
            return new DustParticleOptions(new Vector3f(Vec3.m_82501_((int)0xFFFFFF)), 1.5f);
        }
        if (phoenixType == ExoticBirdsEntities.TWILIGHT_PHOENIX.get()) {
            return new DustColorTransitionOptions(new Vector3f(Vec3.m_82501_((int)329226)), new Vector3f(Vec3.m_82501_((int)16569600)), 1.5f);
        }
        return new DustColorTransitionOptions(DustParticleOptions.f_175788_, new Vector3f(Vec3.m_82501_((int)16569600)), 1.5f);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_57012_) {
        p_57012_.m_61104_(new Property[]{WATERLOGGED});
    }
}

