/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.blockentity;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.pavocado.exoticbirds.block.IdentifierBlock;
import net.pavocado.exoticbirds.container.IdentifierMenu;
import net.pavocado.exoticbirds.init.ExoticBirdsBlockEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsBlocks;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.item.BirdEggItem;
import org.jetbrains.annotations.Nullable;

public class IdentifierBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS_FOR_DOWN = IntStream.range(2, 17).toArray();
    private static final int[] SLOTS_FOR_OTHER = new int[]{0, 1};
    public static final int totalHeatTime = 500;
    private ResourceLocation eggLootTable = new ResourceLocation("exoticbirds", "gameplay/egg_analysis");
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int i) {
            switch (i) {
                case 0: {
                    return IdentifierBlockEntity.this.litTime;
                }
                case 1: {
                    return IdentifierBlockEntity.this.litDuration;
                }
                case 2: {
                    return IdentifierBlockEntity.this.cookingProgress;
                }
            }
            return 0;
        }

        public void m_8050_(int i, int val) {
            switch (i) {
                case 0: {
                    IdentifierBlockEntity.this.litTime = val;
                    break;
                }
                case 1: {
                    IdentifierBlockEntity.this.litDuration = val;
                    break;
                }
                case 2: {
                    IdentifierBlockEntity.this.cookingProgress = val;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };
    public ItemStackHandler inventory = new ItemStackHandler(17){

        public int getSlotLimit(int slot) {
            if (slot == 0 || slot == 1) {
                return 64;
            }
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            switch (slot) {
                case 0: {
                    return !stack.m_41619_() && stack.m_41720_() == ExoticBirdsItems.MYSTERY_EGG.get();
                }
                case 1: {
                    return IdentifierBlockEntity.this.isFuel(stack);
                }
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            IdentifierBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalDown;
    private LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalOther;

    private boolean isFuel(ItemStack stack) {
        return IdentifierBlockEntity.getBurnTime(stack) > 0;
    }

    public static int getBurnTime(ItemStack stack) {
        if (!stack.m_41619_()) {
            Item item = stack.m_41720_();
            Map<Item, Integer> fuelMap = IdentifierBlockEntity.getFuel();
            if (fuelMap.containsKey(item)) {
                return fuelMap.get(item);
            }
        }
        return 0;
    }

    public static Map<Item, Integer> getFuel() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        map.put(Items.f_42451_, 200);
        map.put(Blocks.f_50330_.m_5456_(), 1800);
        return map;
    }

    public IdentifierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExoticBirdsBlockEntities.EGG_IDENTIFIER.get(), pos, state);
        this.createCaps();
    }

    public int[] m_7071_(Direction facing) {
        return switch (facing) {
            case Direction.DOWN -> SLOTS_FOR_DOWN;
            default -> SLOTS_FOR_OTHER;
        };
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction facing) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.m_41720_() == ExoticBirdsItems.MYSTERY_EGG.get();
        }
        if (slot == 1) {
            return this.isFuel(stack);
        }
        return false;
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction facing) {
        return true;
    }

    protected Component m_6820_() {
        return new TranslatableComponent(((IdentifierBlock)ExoticBirdsBlocks.EGG_IDENTIFIER.get()).m_7705_());
    }

    protected AbstractContainerMenu m_6555_(int val, Inventory inventory) {
        return new IdentifierMenu(val, inventory, this, this.dataAccess);
    }

    public int m_6643_() {
        return 17;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.getItems(), (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.getItems(), (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack itemstack = this.m_8020_(slot);
        boolean flag = !stack.m_41619_() && stack.m_41656_(itemstack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.setStackInSlot(slot, stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (slot == 0 && !flag) {
            this.cookingProgress = 0;
            this.m_6596_();
        }
    }

    protected NonNullList<ItemStack> getItems() {
        NonNullList stackList = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            stackList.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        return stackList;
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, IdentifierBlockEntity entity) {
        boolean flag = entity.isLit();
        boolean flag1 = false;
        if (entity.isLit()) {
            --entity.litTime;
        }
        ItemStack itemstack = entity.inventory.getStackInSlot(1);
        if (entity.isLit() || !itemstack.m_41619_() && !entity.inventory.getStackInSlot(0).m_41619_()) {
            if (!entity.isLit() && entity.canBurn()) {
                entity.litDuration = entity.litTime = IdentifierBlockEntity.getBurnTime(itemstack);
                if (entity.isLit()) {
                    flag1 = true;
                    if (itemstack.hasContainerItem()) {
                        entity.inventory.setStackInSlot(1, itemstack.getContainerItem());
                    } else if (!itemstack.m_41619_()) {
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            entity.inventory.setStackInSlot(1, itemstack.getContainerItem());
                        }
                    }
                }
            }
            if (entity.isLit() && entity.canBurn()) {
                ++entity.cookingProgress;
                if (entity.cookingProgress == 500) {
                    entity.cookingProgress = 0;
                    entity.burn();
                }
            } else {
                entity.cookingProgress = 0;
            }
        } else if (!entity.isLit() && entity.cookingProgress > 0) {
            entity.cookingProgress = Mth.m_14045_((int)(entity.cookingProgress - 2), (int)0, (int)500);
        }
        if (flag != entity.isLit()) {
            flag1 = true;
            state = (BlockState)state.m_61124_((Property)IdentifierBlock.LIT, (Comparable)Boolean.valueOf(entity.isLit()));
            level.m_7731_(pos, state, 3);
        }
        if (flag1) {
            IdentifierBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private boolean canBurn() {
        if (!this.inventory.getStackInSlot(0).m_41619_()) {
            for (int i = 2; i < this.m_6643_(); ++i) {
                if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean burn() {
        if (this.canBurn()) {
            ItemStack itemstack = this.inventory.getStackInSlot(0);
            ItemStack eggStack = this.getAnalysisOutput();
            if (eggStack.m_41720_() instanceof BirdEggItem) {
                CompoundTag tag = eggStack.m_41698_("EggValues");
                tag.m_128405_("SpawnChance", 50 + (int)(Math.log(Math.random() + 1.0) * 4.0) * 10);
                ((BirdEggItem)eggStack.m_41720_()).setEggVariant(eggStack, this.f_58857_);
            }
            for (int i = 2; i < 17; ++i) {
                if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
                this.inventory.setStackInSlot(i, eggStack);
                break;
            }
            itemstack.m_41774_(1);
            return true;
        }
        return false;
    }

    private ItemStack getAnalysisOutput() {
        if (this.f_58857_ != null && this.f_58857_.m_142572_() != null) {
            LootTable loottable = this.f_58857_.m_142572_().m_129898_().m_79217_(this.eggLootTable);
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_58857_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_78977_(this.f_58857_.f_46441_);
            List list = loottable.m_79129_(builder.m_78975_(LootContextParamSets.f_81411_));
            for (ItemStack itemstack : list) {
                if (itemstack.m_41619_()) continue;
                return itemstack;
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        this.litTime = tag.m_128451_("BurnTime");
        this.cookingProgress = tag.m_128451_("CookTime");
        this.litDuration = IdentifierBlockEntity.getBurnTime(this.m_8020_(1));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("BurnTime", this.litTime);
        tag.m_128405_("CookTime", this.cookingProgress);
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
    }

    private void createCaps() {
        this.inventoryCapabilityExternalDown = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 2, 17));
        this.inventoryCapabilityExternalOther = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 2));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side != null) {
            return switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> this.inventoryCapabilityExternalDown.cast();
                case Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST -> this.inventoryCapabilityExternalOther.cast();
            };
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapabilityExternalDown.invalidate();
        this.inventoryCapabilityExternalOther.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.createCaps();
    }
}

