/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.capabilities;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import net.pavocado.exoticbirds.capabilities.BirdTracking;

public class BirdTrackingProvider
implements ICapabilitySerializable<ListTag> {
    public static final Capability<BirdTracking> BIRD_TRACKING_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<BirdTracking>(){});
    private final LazyOptional<BirdTracking> birdTrackingLazyOptional = LazyOptional.of(BirdTracking::new);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return BIRD_TRACKING_CAPABILITY.orEmpty(cap, this.birdTrackingLazyOptional);
    }

    public void invalidateCaps() {
        this.birdTrackingLazyOptional.invalidate();
    }

    public ListTag serializeNBT() {
        ListTag listnbt = new ListTag();
        this.birdTrackingLazyOptional.ifPresent(instance -> {
            for (Map.Entry<EntityType<?>, Integer> pair : instance.getAll()) {
                EntityType<?> entityType = pair.getKey();
                if (entityType == null) continue;
                int birdVariant = pair.getValue();
                CompoundTag tag = new CompoundTag();
                ResourceLocation location = ForgeRegistries.ENTITIES.getKey(entityType);
                if (location == null) continue;
                tag.m_128359_("id", location.toString());
                tag.m_128376_("variant", (short)birdVariant);
                listnbt.add((Object)tag);
            }
        });
        return listnbt;
    }

    public void deserializeNBT(ListTag listnbt) {
        this.birdTrackingLazyOptional.ifPresent(instance -> {
            HashSet trackedBirds = new HashSet();
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundTag tag = listnbt.m_128728_(i);
                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(tag.m_128461_("id")));
                if (entityType == null) continue;
                trackedBirds.add(new AbstractMap.SimpleEntry<EntityType, Integer>(entityType, tag.m_128451_("variant")));
            }
            instance.setAll(trackedBirds);
        });
    }
}

