/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.LyrebirdEntity;

@OnlyIn(value=Dist.CLIENT)
public class LyrebirdModel<T extends LyrebirdEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation LYREBIRD_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "lyrebird"), "main");
    private final ModelPart breast;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart beak;
    private final ModelPart back;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightAnkle;
    private final ModelPart rightFoot;
    private final ModelPart midLeftTrain;
    private final ModelPart midTrain;
    private final ModelPart outerLeftTrain;
    private final ModelPart midRightTrain;
    private final ModelPart outerRightTrain;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart leftAnkle;
    private final ModelPart leftFoot;

    public LyrebirdModel(ModelPart part) {
        this.breast = part.m_171324_("breast");
        this.neck = part.m_171324_("neck");
        this.head = part.m_171324_("head");
        this.beak = part.m_171324_("beak");
        this.back = part.m_171324_("back");
        this.rightLeg = part.m_171324_("rightLeg");
        this.leftLeg = part.m_171324_("leftLeg");
        this.rightAnkle = part.m_171324_("rightAnkle");
        this.rightFoot = part.m_171324_("rightFoot");
        this.midLeftTrain = part.m_171324_("midLeftTrain");
        this.midTrain = part.m_171324_("midTrain");
        this.outerLeftTrain = part.m_171324_("outerLeftTrain");
        this.midRightTrain = part.m_171324_("midRightTrain");
        this.outerRightTrain = part.m_171324_("outerRightTrain");
        this.rightWing = part.m_171324_("rightWing");
        this.leftWing = part.m_171324_("leftWing");
        this.leftAnkle = part.m_171324_("leftAnkle");
        this.leftFoot = part.m_171324_("leftFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("breast", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, -2.0f, 0.0f, 5.0f, 4.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)-3.0f, (float)-0.2617994f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(17, 20).m_171481_(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)-2.0f, (float)0.3490659f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171481_(-1.5f, -5.0f, -1.8f, 3.0f, 2.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)-2.0f, (float)0.3490659f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171481_(-1.0f, -4.2f, -3.4f, 2.0f, 1.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)-2.0f, (float)0.3490659f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-2.0f, -2.0f, 0.0f, 4.0f, 3.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)19.2f, (float)1.0f, (float)-0.4461433f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-1.1f, (float)20.0f, (float)1.0f, (float)-0.1570796f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(8, 23).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)1.1f, (float)20.0f, (float)1.0f, (float)-0.1570796f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightAnkle", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171481_(-0.5f, 1.2f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)-1.1f, (float)20.0f, (float)1.0f, (float)-0.30125f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(8, 27).m_171481_(-1.0f, 4.0f, -6.0f, 2.0f, 0.0f, 3.0f), PartPose.m_171423_((float)-1.1f, (float)20.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("midLeftTrain", CubeListBuilder.m_171558_().m_171514_(24, 9).m_171481_(-1.0f, 0.0f, -0.9f, 3.0f, 0.0f, 10.0f), PartPose.m_171423_((float)0.0f, (float)20.5f, (float)3.0f, (float)0.1396263f, (float)0.1919862f, (float)-0.1396263f));
        partdefinition.m_171599_("midTrain", CubeListBuilder.m_171558_().m_171514_(18, 9).m_171481_(-1.5f, 0.0f, 0.3f, 3.0f, 0.0f, 10.0f), PartPose.m_171423_((float)0.0f, (float)20.5f, (float)3.0f, (float)0.1047198f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("outerLeftTrain", CubeListBuilder.m_171558_().m_171514_(18, 21).m_171481_(-0.6f, 0.0f, -0.9f, 3.0f, 0.0f, 11.0f), PartPose.m_171423_((float)0.0f, (float)20.5f, (float)3.0f, (float)0.1745329f, (float)0.3490659f, (float)-0.2792527f));
        partdefinition.m_171599_("midRightTrain", CubeListBuilder.m_171558_().m_171514_(12, 9).m_171481_(-2.0f, 0.0f, -0.9f, 3.0f, 0.0f, 10.0f), PartPose.m_171423_((float)0.0f, (float)20.5f, (float)3.0f, (float)0.1396263f, (float)-0.1919862f, (float)0.1396263f));
        partdefinition.m_171599_("outerRightTrain", CubeListBuilder.m_171558_().m_171514_(24, 21).m_171481_(-2.4f, 0.0f, -0.9f, 3.0f, 0.0f, 11.0f), PartPose.m_171423_((float)0.0f, (float)20.5f, (float)3.0f, (float)0.1745329f, (float)-0.3490659f, (float)0.2792527f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-1.0f, -1.0f, -1.0f, 1.0f, 3.0f, 5.0f), PartPose.m_171423_((float)-2.3f, (float)18.0f, (float)-1.0f, (float)-0.2443461f, (float)0.1570796f, (float)0.0f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171481_(0.0f, -1.0f, -1.0f, 1.0f, 3.0f, 5.0f), PartPose.m_171423_((float)2.3f, (float)18.0f, (float)-1.0f, (float)-0.2443461f, (float)-0.1570796f, (float)0.0f));
        partdefinition.m_171599_("leftAnkle", CubeListBuilder.m_171558_().m_171514_(4, 27).m_171481_(-0.5f, 1.2f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)1.1f, (float)20.0f, (float)1.0f, (float)-0.30125f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(18, 27).m_171481_(-1.0f, 4.0f, -3.0f, 2.0f, 0.0f, 3.0f), PartPose.m_171423_((float)1.1f, (float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.neck, (Object)this.head, (Object)this.beak);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.breast, (Object)this.back, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.rightAnkle, (Object)this.rightFoot, (Object)this.midLeftTrain, (Object)this.midTrain, (Object)this.outerLeftTrain, (Object)this.midRightTrain, (Object)this.outerRightTrain, (Object)this.rightWing, (Object[])new ModelPart[]{this.leftWing, this.leftAnkle, this.leftFoot});
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = -(headPitch / 57.295776f) + 0.3490659f;
        this.beak.f_104204_ = this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.beak.f_104203_ = -(headPitch / 57.295776f) + 0.3490659f;
        this.neck.f_104204_ = this.head.f_104204_;
        this.neck.f_104203_ = -(headPitch / 57.295776f) + 0.3490659f;
        this.rightAnkle.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount - 0.30125f;
        this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftAnkle.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount - 0.30125f;
        this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightWing.f_104205_ = ageInTicks;
        this.leftWing.f_104205_ = -ageInTicks;
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.7f, 0.7f, 0.7f);
            stack.m_85837_(0.0, (double)0.6f, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        } else {
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
        }
    }
}

