/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.AbstractFlyingBirdEntity;
import net.pavocado.exoticbirds.entity.PigeonEntity;

@OnlyIn(value=Dist.CLIENT)
public class PigeonModel<T extends PigeonEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation PIGEON_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "pigeon"), "main");
    private final ModelPart body;
    private final ModelPart neck;
    private final ModelPart upperBeak;
    private final ModelPart back;
    private final ModelPart tail;
    private final ModelPart head;
    private final ModelPart lowerBeak;
    private final ModelPart spine;
    private final ModelPart rightLeg;
    private final ModelPart rightFoot;
    private final ModelPart leftLeg;
    private final ModelPart leftFoot;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart leftWingLong;
    private final ModelPart rightWingLong;

    public PigeonModel(ModelPart part) {
        this.body = part.m_171324_("body");
        this.neck = part.m_171324_("neck");
        this.upperBeak = part.m_171324_("upperBeak");
        this.back = part.m_171324_("back");
        this.tail = part.m_171324_("tail");
        this.head = part.m_171324_("head");
        this.lowerBeak = part.m_171324_("lowerBeak");
        this.spine = part.m_171324_("spine");
        this.rightLeg = part.m_171324_("rightLeg");
        this.rightFoot = part.m_171324_("rightFoot");
        this.leftLeg = part.m_171324_("leftLeg");
        this.leftFoot = part.m_171324_("leftFoot");
        this.rightWing = part.m_171324_("rightWing");
        this.leftWing = part.m_171324_("leftWing");
        this.leftWingLong = part.m_171324_("leftWingLong");
        this.rightWingLong = part.m_171324_("rightWingLong");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-2.7f, (float)-0.4363323f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 3.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-2.5f, (float)0.0855211f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("upperBeak", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171481_(-1.0f, -3.8f, -3.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 10.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)16.4f, (float)-2.0f, (float)0.9773844f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(16, 11).m_171481_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)21.3f, (float)3.0f, (float)-0.183621f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(-1.5f, -5.2f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("lowerBeak", CubeListBuilder.m_171558_().m_171514_(39, 0).m_171481_(-1.0f, -4.4f, -2.1f, 2.0f, 1.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)-2.5f, (float)0.226893f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("spine", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171481_(-2.0f, -1.0f, 0.0f, 4.0f, 3.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)19.8f, (float)1.0f, (float)-0.2747086f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(35, 3).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)-1.0f, (float)21.0f, (float)0.0f, (float)-0.2094395f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(31, 10).m_171481_(-1.0f, 2.8f, -2.5f, 2.0f, 0.0f, 3.0f), PartPose.m_171423_((float)-1.0f, (float)21.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(31, 3).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)1.0f, (float)21.0f, (float)0.0f, (float)-0.2094395f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(31, 7).m_171481_(-1.0f, 2.8f, -2.5f, 2.0f, 0.0f, 3.0f), PartPose.m_171423_((float)1.0f, (float)21.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(31, 11).m_171481_(0.0f, -1.0f, -1.0f, 0.0f, 4.0f, 6.0f), PartPose.m_171423_((float)-2.5f, (float)17.0f, (float)-1.0f, (float)-0.4363323f, (float)0.0349066f, (float)0.1047198f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(31, 7).m_171481_(0.0f, -1.0f, -1.0f, 0.0f, 4.0f, 6.0f), PartPose.m_171423_((float)2.5f, (float)17.0f, (float)-1.0f, (float)-0.4363323f, (float)-0.0349066f, (float)-0.1047198f));
        partdefinition.m_171599_("leftWingLong", CubeListBuilder.m_171558_().m_171514_(43, 15).m_171481_(0.0f, -1.0f, -3.0f, 0.0f, 8.0f, 6.0f), PartPose.m_171423_((float)2.5f, (float)17.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.361357f));
        partdefinition.m_171599_("rightWingLong", CubeListBuilder.m_171558_().m_171514_(31, 15).m_171481_(0.0f, -1.0f, -3.0f, 0.0f, 8.0f, 6.0f), PartPose.m_171423_((float)-2.5f, (float)17.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.375609f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.neck, (Object)this.upperBeak, (Object)this.head, (Object)this.lowerBeak);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.back, (Object)this.tail, (Object)this.spine, (Object)this.rightLeg, (Object)this.rightFoot, (Object)this.leftLeg, (Object)this.leftFoot, (Object)this.rightWing, (Object)this.leftWing, (Object)this.leftWingLong, (Object)this.rightWingLong, (Object[])new ModelPart[0]);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.lowerBeak.f_104204_ = this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.upperBeak.f_104204_ = this.head.f_104204_;
        this.rightWing.f_104205_ = ageInTicks;
        this.leftWing.f_104205_ = -ageInTicks;
        if (!((AbstractFlyingBirdEntity)((Object)entityIn)).m_142592_()) {
            this.head.f_104203_ = -(headPitch / 57.295776f);
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount - 0.2094395f;
            this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount - 0.2094395f;
            this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        } else {
            this.head.f_104203_ = 0.9f;
            this.rightLeg.f_104203_ = 0.98f;
            this.rightFoot.f_104203_ = 1.48f;
            this.leftLeg.f_104203_ = 0.98f;
            this.leftFoot.f_104203_ = 1.48f;
            this.leftWingLong.f_104205_ = Mth.m_14089_((float)(limbSwing * 1.0f)) * 0.4f - 1.575609f;
            this.rightWingLong.f_104205_ = -this.leftWingLong.f_104205_;
        }
        this.lowerBeak.f_104203_ = this.head.f_104203_ + 0.226893f;
        this.upperBeak.f_104203_ = this.head.f_104203_;
        this.rightWingLong.f_104207_ = !entityIn.m_20096_();
        this.leftWingLong.f_104207_ = !entityIn.m_20096_();
        this.rightWing.f_104207_ = entityIn.m_20096_();
        this.leftWing.f_104207_ = entityIn.m_20096_();
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.4f, 0.4f, 0.4f);
            stack.m_85837_(0.0, (double)2.2f, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        } else {
            stack.m_85836_();
            stack.m_85841_(0.8f, 0.8f, 0.8f);
            stack.m_85837_(0.0, (double)0.34f, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        }
    }
}

