/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsSoundEvents;

public abstract class AbstractPhoenixEntity
extends AbstractBirdEntity
implements PlayerRideable,
Saddleable,
IForgeShearable {
    protected static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExoticBirdsItems.AMBROSIA.get()});
    private static final EntityDataAccessor<Boolean> DATA_SADDLED = SynchedEntityData.m_135353_(AbstractPhoenixEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected boolean ascending;
    protected boolean descending;

    public AbstractPhoenixEntity(EntityType<? extends AbstractPhoenixEntity> type, Level level, ItemStack eggIn) {
        super(type, level, eggIn, 1, true, false);
        this.f_19793_ = 1.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SADDLED, (Object)false);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return size.f_20378_ * 0.85f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 2.0);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ExoticBirdsSoundEvents.ENTITY_PHOENIX_AMBIENT.get();
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Saddle", this.m_6254_());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSaddle(tag.m_128471_("Saddle"));
    }

    public void setSaddle(boolean saddle) {
        this.f_19804_.m_135381_(DATA_SADDLED, (Object)saddle);
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_146895_();
    }

    public boolean m_5807_() {
        return this.m_6688_() instanceof Player;
    }

    @Override
    public boolean canLayEggs() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            this.spawnAmbientParticles();
        }
    }

    public abstract void spawnAmbientParticles();

    @Override
    protected void performFlap() {
        this.canFloat = !this.m_20160_();
        super.performFlap();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        boolean food = this.m_6898_(itemstack);
        if (!food && this.m_6254_() && !this.m_20160_() && !player.m_36341_() && ((Boolean)ExoticBirdsCommonConfig.allowPhoenixRiding.get()).booleanValue()) {
            if (!this.f_19853_.f_46443_) {
                player.m_20329_((Entity)this);
            } else {
                player.m_6352_((Component)new TranslatableComponent("exoticbirds.flight.keys", new Object[]{Minecraft.m_91087_().f_91066_.f_92089_.m_90863_(), Minecraft.m_91087_().f_91066_.f_92091_.m_90863_()}), Util.f_137441_);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (food && this.m_21223_() < this.m_21233_()) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_5634_(10.0f);
            this.m_146859_(GameEvent.f_157771_, this.m_146901_());
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionresult = super.m_6071_(player, hand);
        if (!interactionresult.m_19077_()) {
            return itemstack.m_150930_(Items.f_42450_) ? itemstack.m_41647_(player, (LivingEntity)this, hand) : InteractionResult.PASS;
        }
        return interactionresult;
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_();
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    public void m_5853_(@Nullable SoundSource p_29476_) {
        this.setSaddle(true);
        if (p_29476_ != null) {
            this.f_19853_.m_6269_((Player)null, (Entity)this, SoundEvents.f_12236_, p_29476_, 0.5f, 1.0f);
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() && this.m_20160_() && this.m_6254_();
    }

    public void m_7023_(Vec3 motion) {
        if (this.m_6084_()) {
            this.m_20242_(this.m_20160_());
            if (this.m_20160_() && this.m_5807_() && this.m_6254_() && ((Boolean)ExoticBirdsCommonConfig.allowPhoenixRiding.get()).booleanValue()) {
                LivingEntity livingentity = (LivingEntity)this.m_6688_();
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20883_ = this.m_146908_();
                this.f_20885_ = this.m_146908_();
                this.f_20887_ = this.m_6113_() * 0.1f;
                float f = livingentity.f_20900_ * 0.5f;
                float f1 = livingentity.f_20902_;
                float ySpeed = 0.0f;
                if (this.descending) {
                    ySpeed = -0.5f;
                }
                if (this.ascending) {
                    ySpeed = 0.5f;
                }
                this.f_20887_ = this.m_6113_() * 0.2f;
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    super.m_7023_(new Vec3((double)f, (double)ySpeed, (double)f1));
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_21043_((LivingEntity)this, false);
                this.m_146872_();
            } else {
                this.descending = false;
                this.ascending = false;
                this.f_20887_ = 0.02f;
                super.m_7023_(motion);
            }
        }
    }

    public double m_6048_() {
        return (double)this.m_6972_((Pose)Pose.STANDING).f_20378_ / 3.0 + 0.145;
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SADDLED);
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    public Vec3 m_7688_(LivingEntity p_29487_) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(p_29487_);
        }
        int[][] aint = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockpos = this.m_142538_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Pose pose : p_29487_.m_7431_()) {
            AABB aabb = p_29487_.m_21270_(pose);
            for (int[] aint1 : aint) {
                Vec3 vec3;
                blockpos$mutableblockpos.m_122178_(blockpos.m_123341_() + aint1[0], blockpos.m_123342_(), blockpos.m_123343_() + aint1[1]);
                double d0 = this.f_19853_.m_45573_((BlockPos)blockpos$mutableblockpos);
                if (!DismountHelper.m_38439_((double)d0) || !DismountHelper.m_38456_((CollisionGetter)this.f_19853_, (LivingEntity)p_29487_, (AABB)aabb.m_82383_(vec3 = Vec3.m_82514_((Vec3i)blockpos$mutableblockpos, (double)d0)))) continue;
                p_29487_.m_20124_(pose);
                return vec3;
            }
        }
        return super.m_7688_(p_29487_);
    }

    public int getGlowLevel() {
        return 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getTranslatedFamilyName() {
        return new TranslatableComponent("exoticbirds.family.mythical");
    }

    @Override
    public List<String> getBlacklistedDimensions() {
        return new ArrayList<String>();
    }

    @Override
    public List<ItemStack> getTamingItems() {
        return Arrays.asList(new ItemStack((ItemLike)Items.f_42450_));
    }

    public void setAscend(boolean b) {
        this.ascending = b;
    }

    public void setDescend(boolean b) {
        this.descending = b;
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return this.m_6084_() && this.m_6254_() && !this.m_20160_();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        world.m_6269_(null, (Entity)this, SoundEvents.f_12344_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        if (!world.f_46443_) {
            this.setSaddle(false);
            return Arrays.asList(new ItemStack((ItemLike)Items.f_42450_));
        }
        return Collections.emptyList();
    }

    @Override
    public List<ItemStack> getTemptingItems() {
        return Arrays.asList(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExoticBirdsItems.AMBROSIA.get()}).m_43908_());
    }
}

