/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.entity.AbstractWadingBirdEntity;
import net.pavocado.exoticbirds.entity.ai.BirdBreedGoal;
import net.pavocado.exoticbirds.entity.ai.LayEggInNestGoal;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsSoundEvents;

public class FlamingoEntity
extends AbstractWadingBirdEntity {
    private static final EntityDataAccessor<Boolean> DATA_LEG_STANDING = SynchedEntityData.m_135353_(FlamingoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_, Items.f_42528_});
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_andean.png"));
        hashMap.put(1, new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_caribbean.png"));
        hashMap.put(2, new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_chilean.png"));
        hashMap.put(3, new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_greater.png"));
        hashMap.put(4, new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_james.png"));
        hashMap.put(5, new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_lesser.png"));
        hashMap.put(6, new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_greater_black.png"));
    });

    public FlamingoEntity(EntityType<? extends FlamingoEntity> type, Level level) {
        super(type, level, new ItemStack((ItemLike)ExoticBirdsItems.FLAMINGO_EGG.get()), BIRD_TEXTURES.size(), true, false);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BirdBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new LayEggInNestGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new StandOnOneLeg(this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_LEG_STANDING, (Object)false);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return this.m_6162_() ? size.f_20378_ * 0.85f : size.f_20378_ * 0.92f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ExoticBirdsSoundEvents.ENTITY_FLAMINGO_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ExoticBirdsSoundEvents.ENTITY_FLAMINGO_AMBIENT.get();
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    public FlamingoEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        FlamingoEntity flamingo = (FlamingoEntity)((EntityType)ExoticBirdsEntities.FLAMINGO.get()).m_20615_((Level)serverLevel);
        flamingo.setVariant(this.getChildVariant());
        return flamingo;
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    @Override
    public int getRandomVariant() {
        if (this.f_19796_.nextInt(80) == 0) {
            return 6;
        }
        return this.f_19796_.nextInt(6);
    }

    public boolean getIsStanding() {
        return (Boolean)this.f_19804_.m_135370_(DATA_LEG_STANDING);
    }

    public void setIsStanding(boolean isStanding) {
        this.f_19804_.m_135381_(DATA_LEG_STANDING, (Object)isStanding);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("StandingBool", this.getIsStanding());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setIsStanding(tag.m_128471_("StandingBool"));
    }

    @Override
    public List<String> getBlacklistedDimensions() {
        return (List)ExoticBirdsCommonConfig.blacklistedDimensionsFlamingo.get();
    }

    @Override
    public List<ItemStack> getTemptingItems() {
        return Arrays.asList(FOOD_ITEMS.m_43908_());
    }

    public static class StandOnOneLeg
    extends Goal {
        private final FlamingoEntity flamingo;
        private int standTime;

        public StandOnOneLeg(FlamingoEntity entity) {
            this.flamingo = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.flamingo.m_20072_()) {
                return false;
            }
            if (!this.flamingo.m_20096_()) {
                return false;
            }
            return this.flamingo.getIsStanding() || this.flamingo.m_21187_().nextInt(400) == 0;
        }

        public boolean m_8045_() {
            return this.standTime > 0;
        }

        public void m_8056_() {
            this.flamingo.m_21573_().m_26573_();
            this.flamingo.setIsStanding(true);
            this.standTime = this.m_183277_(1000 + this.flamingo.m_21187_().nextInt(500));
        }

        public void m_8041_() {
            this.flamingo.setIsStanding(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            --this.standTime;
        }
    }
}

