/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.geheimagentnr1.world_pre_generator.config.ServerConfig;
import de.geheimagentnr1.world_pre_generator.elements.commands.arguments.world_pos.WorldPosArgument;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.PregenTask;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.WorldPos;
import de.geheimagentnr1.world_pre_generator.elements.workers.PregenWorker;
import de.geheimagentnr1.world_pre_generator.helpers.DimensionHelper;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class PregenCommand {
    private static PregenWorker pregenWorker;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, PregenWorker _pregenWorker) {
        LiteralArgumentBuilder pregenCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"pregen").requires(source -> source.m_6761_(2));
        pregenCommand.then(Commands.m_82127_((String)"list").executes(PregenCommand::printList));
        pregenCommand.then(Commands.m_82127_((String)"start").then(Commands.m_82129_((String)"center", (ArgumentType)WorldPosArgument.worldPos()).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(PregenCommand::start)))));
        pregenCommand.then(Commands.m_82127_((String)"resume").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(PregenCommand::resume)));
        pregenCommand.then(Commands.m_82127_((String)"pause").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(PregenCommand::pause)));
        pregenCommand.then(Commands.m_82127_((String)"cancel").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(PregenCommand::cancel)));
        pregenCommand.then(Commands.m_82127_((String)"clear").executes(PregenCommand::clear));
        pregenCommand.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"sendFeedback").executes(PregenCommand::showSendFeedback)).then(Commands.m_82129_((String)"isFeedbackEnabled", (ArgumentType)BoolArgumentType.bool()).executes(PregenCommand::setSendFeedback)));
        dispatcher.register(pregenCommand);
        pregenWorker = _pregenWorker;
    }

    private static void printTasks(CommandSourceStack source, ArrayList<PregenTask> tasks) {
        for (PregenTask task : tasks) {
            source.m_81354_((Component)new TextComponent(String.format("%s %d %d %d", DimensionHelper.getNameOfDim(task.getDimension()), task.getCenterX(), task.getCenterZ(), task.getRadius())), false);
        }
    }

    private static int printList(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (pregenWorker.getQueue().noTasks()) {
            source.m_81354_((Component)new TextComponent("Pregeneration Tasklist is empty."), false);
        } else {
            source.m_81354_((Component)new TextComponent("Pregeneration Tasklist:"), false);
            ArrayList<PregenTask> activeTasks = pregenWorker.getQueue().getActiveTasks();
            ArrayList<PregenTask> pausedTasks = pregenWorker.getQueue().getPausedTasks();
            if (!activeTasks.isEmpty()) {
                source.m_81354_((Component)new TextComponent("Queued Tasks:"), false);
                PregenCommand.printTasks(source, activeTasks);
            }
            if (!pausedTasks.isEmpty()) {
                source.m_81354_((Component)new TextComponent("Paused Tasks:"), false);
                PregenCommand.printTasks(source, pausedTasks);
            }
        }
        return 1;
    }

    private static int start(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        WorldPos center = WorldPosArgument.getWorldPos(context, "center");
        int radius = IntegerArgumentType.getInteger(context, (String)"radius");
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        pregenWorker.getQueue().startTask(new PregenTask(center, radius, (ResourceKey<Level>)dimension));
        source.m_81354_((Component)new TextComponent(String.format("Task for %s got queued.", DimensionHelper.getNameOfDim((ResourceKey<Level>)dimension))), true);
        return 1;
    }

    private static int resume(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        pregenWorker.getQueue().resumeTask((ResourceKey<Level>)dimension);
        source.m_81354_((Component)new TextComponent(String.format("Task for %s was resumed.", DimensionHelper.getNameOfDim((ResourceKey<Level>)dimension))), true);
        return 1;
    }

    private static int pause(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        pregenWorker.getQueue().pauseTask((ResourceKey<Level>)dimension);
        source.m_81354_((Component)new TextComponent(String.format("Task for %s was paused.", DimensionHelper.getNameOfDim((ResourceKey<Level>)dimension))), true);
        return 1;
    }

    private static int cancel(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        pregenWorker.getQueue().cancelTask((ResourceKey<Level>)dimension);
        source.m_81354_((Component)new TextComponent(String.format("Task for %s was canceled.", DimensionHelper.getNameOfDim((ResourceKey<Level>)dimension))), true);
        return 1;
    }

    private static int clear(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        pregenWorker.getQueue().clear();
        source.m_81354_((Component)new TextComponent("All Task were canceled."), true);
        return 1;
    }

    private static int showSendFeedback(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (ServerConfig.isSendFeedbackEnabled()) {
            source.m_81354_((Component)new TextComponent("Feedback is enabled."), false);
        } else {
            source.m_81354_((Component)new TextComponent("Feedback is disabled."), false);
        }
        return 1;
    }

    private static int setSendFeedback(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerConfig.setSendFeedback(BoolArgumentType.getBool(context, (String)"isFeedbackEnabled"));
        if (ServerConfig.isSendFeedbackEnabled()) {
            source.m_81354_((Component)new TextComponent("Feedback is now enabled."), false);
        } else {
            source.m_81354_((Component)new TextComponent("Feedback is now disabled."), false);
        }
        return 1;
    }
}

