/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.lighting.LayerLightEngine;
import snownee.snow.CoreModule;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.ModSnowLayerBlock;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.SnowCoveredBlockEntity;

public final class Hooks {
    private Hooks() {
    }

    public static boolean canSurvive(BlockState blockState, LevelReader viewableWorld, BlockPos blockPos) {
        BlockPos blockPos2 = blockPos.m_7494_();
        BlockState blockState2 = viewableWorld.m_8055_(blockPos2);
        if (blockState2.m_204336_(CoreModule.BOTTOM_SNOW)) {
            if (blockState2.m_60734_() == Blocks.f_50125_) {
                return SnowCommonConfig.sustainGrassIfLayerMoreThanOne || (Integer)blockState2.m_61143_((Property)SnowLayerBlock.f_56581_) == 1;
            }
            return true;
        }
        int i = LayerLightEngine.m_75667_((BlockGetter)viewableWorld, (BlockState)blockState, (BlockPos)blockPos, (BlockState)blockState2, (BlockPos)blockPos2, (Direction)Direction.UP, (int)blockState2.m_60739_((BlockGetter)viewableWorld, blockPos2));
        return i < viewableWorld.m_7469_();
    }

    public static InteractionResult shouldRenderFaceSnow(BlockState state, BlockGetter level, BlockPos pos, Direction direction, BlockPos relativePos) {
        if (!state.m_60815_()) {
            return InteractionResult.PASS;
        }
        state = level.m_8055_(pos = pos.m_142300_(direction));
        if (!state.m_155947_() || !(state.m_60734_() instanceof SnowVariant)) {
            return InteractionResult.PASS;
        }
        if (direction == Direction.UP) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SnowCoveredBlockEntity && !((SnowCoveredBlockEntity)blockEntity).getState().m_60815_()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel worldgenlevel = ctx.m_159774_();
        BlockPos blockpos = ctx.m_159777_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos belowPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                BlockState blockstate;
                int k = blockpos.m_123341_() + i;
                int l = blockpos.m_123343_() + j;
                int i1 = worldgenlevel.m_6924_(Heightmap.Types.MOTION_BLOCKING, k, l);
                pos.m_122178_(k, i1, l);
                belowPos.m_122190_((Vec3i)pos).m_122175_(Direction.DOWN, 1);
                Biome biome = (Biome)worldgenlevel.m_204166_((BlockPos)pos).m_203334_();
                if (biome.m_47480_((LevelReader)worldgenlevel, (BlockPos)belowPos, false)) {
                    worldgenlevel.m_7731_((BlockPos)belowPos, Blocks.f_50126_.m_49966_(), 2);
                }
                if (biome.m_47519_((LevelReader)worldgenlevel, (BlockPos)pos)) {
                    worldgenlevel.m_7731_((BlockPos)pos, Blocks.f_50125_.m_49966_(), 2);
                    blockstate = worldgenlevel.m_8055_((BlockPos)belowPos);
                    if (!blockstate.m_61138_((Property)SnowyDirtBlock.f_56637_)) continue;
                    worldgenlevel.m_7731_((BlockPos)belowPos, (BlockState)blockstate.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)), 2);
                    continue;
                }
                if (!SnowCommonConfig.replaceWorldFeature || !SnowCommonConfig.canPlaceSnowInBlock() || biome.m_198906_((BlockPos)pos) || worldgenlevel.m_45517_(LightLayer.BLOCK, (BlockPos)pos) >= 10 || !CoreModule.BLOCK.defaultBlockState().m_60710_((LevelReader)worldgenlevel, (BlockPos)pos) || !ModSnowLayerBlock.convert((LevelAccessor)worldgenlevel, (BlockPos)pos, blockstate = worldgenlevel.m_8055_((BlockPos)pos), 1, 2) || !(blockstate = worldgenlevel.m_8055_((BlockPos)belowPos)).m_61138_((Property)SnowyDirtBlock.f_56637_)) continue;
                worldgenlevel.m_7731_((BlockPos)belowPos, (BlockState)blockstate.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        return true;
    }
}

