/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.mixin;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.lang3.tuple.Triple;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import snownee.snow.client.ClientVariables;
import snownee.snow.client.SnowVariantMetadataSectionSerializer;
import snownee.snow.client.model.ModelDefinition;
import snownee.snow.client.model.SnowVariantModel;

@Mixin(value={ModelBakery.class})
public abstract class ModelBakeryMixin {
    @Shadow
    private Set<ResourceLocation> f_119210_;
    @Shadow
    private Map<ResourceLocation, UnbakedModel> f_119214_;
    private final Set<ResourceLocation> snowModels = Sets.newHashSet();

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/block/model/BlockModel;fromStream(Ljava/io/Reader;)Lnet/minecraft/client/renderer/block/model/BlockModel;", shift=At.Shift.BY, by=2)}, method={"loadBlockModel"}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void srm_loadBlockModel(ResourceLocation resourceLocation, CallbackInfoReturnable<BlockModel> ci, Reader reader, Resource resource, BlockModel blockModel) throws IOException {
        if (resource == null || blockModel == null) {
            return;
        }
        if (resource.m_142564_()) {
            ModelDefinition def = (ModelDefinition)resource.m_5507_((MetadataSectionSerializer)SnowVariantMetadataSectionSerializer.SERIALIZER);
            if (def != null && def.model != null) {
                this.f_119210_.add(def.model);
                this.snowModels.add(def.model);
                ClientVariables.snowVariantMapping.put(resourceLocation, def);
            }
        } else if (this.snowModels.contains(resourceLocation)) {
            this.f_119214_.put(resourceLocation, (UnbakedModel)blockModel);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"bake(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/resources/model/ModelState;Ljava/util/function/Function;)Lnet/minecraft/client/resources/model/BakedModel;"}, locals=LocalCapture.CAPTURE_FAILHARD, remap=false)
    private void srm_bake(ResourceLocation resourceLocation, ModelState modelState, Function<Material, TextureAtlasSprite> sprites, CallbackInfoReturnable<BakedModel> ci, Triple triple, UnbakedModel unbakedModel, BakedModel blockModel) {
        if (!(blockModel instanceof SnowVariantModel) || modelState.getClass() != Variant.class) {
            return;
        }
        ModelDefinition def = ClientVariables.snowVariantMapping.get(resourceLocation);
        if (def != null) {
            Variant variantState = (Variant)modelState;
            variantState = new Variant(def.model, variantState.m_6189_(), variantState.m_7538_(), variantState.m_111886_());
            BakedModel model = ((ModelBakery)this).bake(def.model, (ModelState)variantState, sprites);
            ((SnowVariantModel)blockModel).setSnowVariant(model);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"uploadTextures"})
    private void srm_uploadTextures(TextureManager textureManager, ProfilerFiller profilerFiller, CallbackInfoReturnable<AtlasSet> ci) {
        this.snowModels.clear();
    }
}

