/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server;

import atomicstryker.dynamiclights.server.DynamicLights;
import atomicstryker.dynamiclights.server.IDynamicLightSource;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class DynamicLightSourceContainer {
    private final IDynamicLightSource lightSource;
    private final BlockPos.MutableBlockPos activeLightPos = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos curSourcePos = new BlockPos.MutableBlockPos();
    private final int yOffset;
    final int[][] candidatePositionOffsets = new int[][]{{0, 0, 0}, {0, 0, 1}, {0, 0, -1}, {1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}};

    public DynamicLightSourceContainer(IDynamicLightSource light) {
        this.lightSource = light;
        this.yOffset = (int)Math.floor(light.getAttachmentEntity().m_20192_());
    }

    public boolean onUpdate() {
        BlockPos nextPos;
        Entity ent = this.lightSource.getAttachmentEntity();
        if (!ent.m_6084_()) {
            return true;
        }
        if (this.hasEntityMoved(ent) && (nextPos = this.findNewCurLightPos(ent.f_19853_)) != null && !nextPos.equals((Object)this.activeLightPos)) {
            this.removeLight(ent.f_19853_);
            this.addLight(ent.f_19853_, nextPos, this.lightSource.getLightLevel());
        }
        return false;
    }

    public BlockPos getLightPos() {
        return this.activeLightPos;
    }

    public IDynamicLightSource getLightSource() {
        return this.lightSource;
    }

    private boolean hasEntityMoved(Entity ent) {
        BlockPos newPos = ent.m_142538_().m_142082_(0, this.yOffset, 0);
        if (!newPos.equals((Object)this.curSourcePos)) {
            this.curSourcePos.m_122190_((Vec3i)newPos);
            return true;
        }
        return false;
    }

    public void removeLight(Level world) {
        Block previousBlock = world.m_8055_((BlockPos)this.activeLightPos).m_60734_();
        for (Map.Entry<Block, Block> vanillaBlockToLitBlockEntry : DynamicLights.vanillaBlocksToLitBlocksMap.entrySet()) {
            if (!vanillaBlockToLitBlockEntry.getValue().equals(previousBlock)) continue;
            world.m_7731_((BlockPos)this.activeLightPos, vanillaBlockToLitBlockEntry.getKey().m_49966_(), 3);
        }
    }

    private BlockPos findNewCurLightPos(Level world) {
        for (int[] offsetTriple : this.candidatePositionOffsets) {
            BlockPos posWithOffset = this.curSourcePos.m_142082_(offsetTriple[0], offsetTriple[1], offsetTriple[2]);
            BlockState blockState = world.m_8055_(posWithOffset);
            Block currentBlock = blockState.m_60734_();
            for (Map.Entry<Block, Block> vanillaBlockToLitBlockEntry : DynamicLights.vanillaBlocksToLitBlocksMap.entrySet()) {
                if (!currentBlock.equals(vanillaBlockToLitBlockEntry.getKey()) || currentBlock instanceof LiquidBlock && (Integer)blockState.m_61143_((Property)LiquidBlock.f_54688_) != 0) continue;
                return posWithOffset;
            }
        }
        return null;
    }

    private void addLight(Level world, BlockPos nextPos, int lightLevel) {
        BlockState blockState = world.m_8055_(nextPos);
        Block currentBlock = blockState.m_60734_();
        for (Map.Entry<Block, Block> vanillaBlockToLitBlockEntry : DynamicLights.vanillaBlocksToLitBlocksMap.entrySet()) {
            if (!currentBlock.equals(vanillaBlockToLitBlockEntry.getKey())) continue;
            world.m_7731_(nextPos, (BlockState)vanillaBlockToLitBlockEntry.getValue().m_49966_().m_61124_((Property)BlockStateProperties.f_61426_, (Comparable)Integer.valueOf(lightLevel)), 3);
            world.m_186460_(nextPos, vanillaBlockToLitBlockEntry.getValue(), 150);
            this.activeLightPos.m_122190_((Vec3i)nextPos);
            break;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof DynamicLightSourceContainer) {
            DynamicLightSourceContainer other = (DynamicLightSourceContainer)o;
            if (other.lightSource == this.lightSource) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.lightSource.getAttachmentEntity().hashCode();
    }
}

