/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justenoughprofessions;

import com.mrbysco.justenoughprofessions.compat.CompatibilityHelper;
import com.mrbysco.justenoughprofessions.jei.ProfessionCategory;
import com.mrbysco.justenoughprofessions.jei.ProfessionEntry;
import com.mrbysco.justenoughprofessions.jei.ProfessionWrapper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class ProfessionPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("justenoughprofessions", "jei_plugin");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ProfessionCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42616_), new ResourceLocation[]{ProfessionCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42601_), new ResourceLocation[]{ProfessionCategory.UID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        LinkedList<ProfessionEntry> entries = new LinkedList<ProfessionEntry>();
        for (VillagerProfession profession : ForgeRegistries.PROFESSIONS) {
            LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
            LinkedList<ResourceLocation> knownItems = new LinkedList<ResourceLocation>();
            PoiType poiType = profession.m_35622_();
            for (BlockState state : poiType.f_27325_) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(state.m_60734_().getRegistryName());
                if (block == null) continue;
                ItemStack stack = CompatibilityHelper.compatibilityCheck(new ItemStack((ItemLike)block), profession.getRegistryName());
                ResourceLocation location = stack.m_41720_().getRegistryName();
                if (stack.m_41619_() || knownItems.contains(location)) continue;
                stacks.add(stack);
                knownItems.add(stack.m_41720_().getRegistryName());
            }
            if (stacks.isEmpty()) continue;
            Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
            for (int i = 0; i < stacks.size(); ++i) {
                map.put(i, (Object)((ItemStack)stacks.get(i)));
            }
            entries.add(new ProfessionEntry(profession, (Int2ObjectMap<ItemStack>)map));
        }
        registration.addRecipes(ProfessionPlugin.asRecipes(entries, ProfessionWrapper::new), ProfessionCategory.UID);
    }

    private static <T, R> Collection<R> asRecipes(Collection<T> collection, Function<T, R> transformer) {
        return collection.stream().map(transformer).collect(Collectors.toList());
    }
}

