/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command.subcommand;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.core.CMCommands;
import dev.compactmods.machines.api.core.Messages;
import dev.compactmods.machines.command.argument.RoomPositionArgument;
import dev.compactmods.machines.config.ServerConfig;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.machine.CompactMachineItem;
import dev.compactmods.machines.room.RoomSize;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.room.exceptions.NonexistentRoomException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;

public class CMGiveMachineSubcommand {
    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        LiteralArgumentBuilder subRoot = (LiteralArgumentBuilder)Commands.m_82127_((String)"give").requires(cs -> cs.m_6761_(ServerConfig.giveMachineLevel()));
        subRoot.then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"room", (ArgumentType)RoomPositionArgument.room()).executes(CMGiveMachineSubcommand::giveMachine)));
        return subRoot;
    }

    private static int giveMachine(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        MinecraftServer server = src.m_81377_();
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        ChunkPos roomPos = RoomPositionArgument.get(ctx, "room");
        if (!Rooms.exists(server, roomPos)) {
            CompactMachines.LOGGER.error("Error giving player a new machine block: room not found.");
            src.m_81352_((Component)TranslationUtil.message(Messages.UNKNOWN_ROOM_CHUNK, "%s, %s".formatted(roomPos.f_45578_, roomPos.f_45579_)));
            return -1;
        }
        try {
            RoomSize size = Rooms.sizeOf(server, roomPos);
            ItemStack newItem = new ItemStack((ItemLike)CompactMachineItem.getItemBySize(size));
            CompactMachineItem.setRoom(newItem, roomPos);
            if (!player.m_36356_(newItem)) {
                src.m_81352_((Component)TranslationUtil.command(CMCommands.CANNOT_GIVE_MACHINE));
            } else {
                src.m_81354_((Component)TranslationUtil.command(CMCommands.MACHINE_GIVEN, player.m_5446_()), true);
            }
        }
        catch (NonexistentRoomException e) {
            CompactMachines.LOGGER.fatal((Object)e);
        }
        return 0;
    }
}

