/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.graph;

import dev.compactmods.machines.graph.GraphEdgeType;
import dev.compactmods.machines.graph.GraphNodeType;
import dev.compactmods.machines.graph.IGraphEdgeType;
import dev.compactmods.machines.graph.IGraphNodeType;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class CMGraphRegistration {
    public static final ResourceLocation NODES_RL = new ResourceLocation("compactmachines", "graph_nodes");
    public static final DeferredRegister<IGraphNodeType> NODE_TYPES = DeferredRegister.create((ResourceLocation)NODES_RL, (String)"compactmachines");
    public static final Supplier<IForgeRegistry<IGraphNodeType>> NODE_TYPE_REG = NODE_TYPES.makeRegistry(IGraphNodeType.class, () -> new RegistryBuilder().setName(NODES_RL));
    public static final ResourceLocation EDGES_RL = new ResourceLocation("compactmachines", "graph_edges");
    public static final DeferredRegister<IGraphEdgeType> EDGE_TYPES = DeferredRegister.create((ResourceLocation)EDGES_RL, (String)"compactmachines");
    public static final Supplier<IForgeRegistry<IGraphEdgeType>> EDGE_TYPE_REG = EDGE_TYPES.makeRegistry(IGraphEdgeType.class, () -> new RegistryBuilder().setName(EDGES_RL));
    public static final RegistryObject<IGraphNodeType> MACH_NODE = NODE_TYPES.register("machine", () -> GraphNodeType.MACHINE);
    public static final RegistryObject<IGraphNodeType> DIM_NODE = NODE_TYPES.register("dimension", () -> GraphNodeType.DIMENSION);
    public static final RegistryObject<IGraphNodeType> ROOM_NODE = NODE_TYPES.register("room", () -> GraphNodeType.ROOM);
    public static final RegistryObject<IGraphNodeType> TUNNEL_NODE = NODE_TYPES.register("tunnel", () -> GraphNodeType.TUNNEL);
    public static final RegistryObject<IGraphNodeType> TUNNEL_TYPE_NODE = NODE_TYPES.register("tunnel_type", () -> GraphNodeType.TUNNEL_TYPE);
    public static final RegistryObject<IGraphEdgeType> MACHINE_LINK = EDGE_TYPES.register("machine_link", () -> GraphEdgeType.MACHINE_LINK);
    public static final RegistryObject<IGraphEdgeType> TUNNEL_TYPE = EDGE_TYPES.register("tunnel_type", () -> GraphEdgeType.TUNNEL_TYPE);
    public static final RegistryObject<IGraphEdgeType> TUNNEL_MACHINE_LINK = EDGE_TYPES.register("tunnel_machine", () -> GraphEdgeType.TUNNEL_MACHINE);

    public static void init(IEventBus bus) {
        NODE_TYPES.register(bus);
        EDGE_TYPES.register(bus);
    }
}

