/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine.graph;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.graph.CMGraphRegistration;
import dev.compactmods.machines.graph.IGraphNode;
import dev.compactmods.machines.graph.IGraphNodeType;
import dev.compactmods.machines.location.LevelBlockPosition;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record CompactMachineNode(ResourceKey<Level> dimension, BlockPos position) implements IGraphNode
{
    public static final ResourceLocation TYPE = new ResourceLocation("compactmachines", "machine");
    public static final Codec<CompactMachineNode> CODEC = RecordCodecBuilder.create(i -> i.group((App)Level.f_46427_.fieldOf("dimension").forGetter(CompactMachineNode::dimension), (App)BlockPos.f_121852_.fieldOf("position").forGetter(CompactMachineNode::position), (App)ResourceLocation.f_135803_.fieldOf("type").forGetter(x -> TYPE)).apply((Applicative)i, (dim, pos, type) -> new CompactMachineNode((ResourceKey<Level>)dim, (BlockPos)pos)));

    @Override
    public String toString() {
        return "Compact Machine {%s}".formatted(this.position);
    }

    public LevelBlockPosition dimpos() {
        return new LevelBlockPosition(this.dimension, this.position);
    }

    @Override
    public IGraphNodeType getType() {
        return (IGraphNodeType)CMGraphRegistration.MACH_NODE.get();
    }
}

