/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine.graph.legacy;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.codec.CodecExtensions;
import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.core.Registration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.Logger;

public class LegacyMachineConnections
extends SavedData {
    private static final String DATA_KEY = "compactmachines_connections";
    private final Map<Integer, ChunkPos> machineMapping = new HashMap<Integer, ChunkPos>();

    private LegacyMachineConnections() {
    }

    public static LegacyMachineConnections get(MinecraftServer server) throws MissingDimensionException {
        ServerLevel compactDim = server.m_129880_(Registration.COMPACT_DIMENSION);
        if (compactDim == null) {
            throw new MissingDimensionException();
        }
        return (LegacyMachineConnections)compactDim.m_8895_().m_164858_(LegacyMachineConnections::load, DATA_KEY);
    }

    private static LegacyMachineConnections load(CompoundTag tag) {
        if (!tag.m_128441_("graph")) {
            return null;
        }
        CompoundTag graphTag = tag.m_128469_("graph");
        if (!graphTag.m_128441_("connections")) {
            return null;
        }
        LegacyMachineConnections tmp = new LegacyMachineConnections();
        List connections = (List)ConnectionInfoTag.CODEC.listOf().fieldOf("connections").codec().parse((DynamicOps)NbtOps.f_128958_, (Object)graphTag).getOrThrow(false, arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0));
        connections.forEach(conn -> conn.machines.forEach(mid -> tmp.machineMapping.putIfAbsent((Integer)mid, conn.room)));
        return tmp;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        return tag;
    }

    public ChunkPos getConnectedRoom(int legacyMachineId) {
        if (!this.machineMapping.containsKey(legacyMachineId)) {
            return ChunkPos.f_186419_;
        }
        return this.machineMapping.get(legacyMachineId);
    }

    private record ConnectionInfoTag(ChunkPos room, List<Integer> machines) {
        public static final Codec<ConnectionInfoTag> CODEC = RecordCodecBuilder.create(i -> i.group((App)CodecExtensions.CHUNKPOS.fieldOf("machine").forGetter(ConnectionInfoTag::room), (App)Codec.INT.listOf().fieldOf("connections").forGetter(ConnectionInfoTag::machines)).apply((Applicative)i, ConnectionInfoTag::new));
    }
}

