/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl.opus;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import de.maxhenkel.voicechat.api.opus.OpusEncoderMode;
import de.maxhenkel.voicechat.config.ServerConfig;
import de.maxhenkel.voicechat.opus4j.Opus;
import de.maxhenkel.voicechat.plugins.impl.opus.JavaOpusDecoderImpl;
import de.maxhenkel.voicechat.plugins.impl.opus.JavaOpusEncoderImpl;
import de.maxhenkel.voicechat.plugins.impl.opus.NativeOpusDecoderImpl;
import de.maxhenkel.voicechat.plugins.impl.opus.NativeOpusEncoderImpl;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpusManager {
    private static Boolean nativeOpusCompatible;
    public static Pattern VERSIONING_PATTERN;

    public static boolean isNativeOpusCompatible() {
        if (nativeOpusCompatible == null) {
            Boolean isCompatible = Utils.createSafe(OpusManager::isOpusCompatible, e -> Voicechat.LOGGER.warn("Failed to load native Opus codec: {}", (Object)e.getMessage()));
            if (isCompatible == null) {
                Voicechat.LOGGER.warn("Failed to load native Opus codec - Falling back to Java Opus implementation");
            }
            nativeOpusCompatible = isCompatible != null && isCompatible != false;
        }
        return nativeOpusCompatible;
    }

    public static OpusEncoder createEncoder(int sampleRate, int frameSize, int maxPayloadSize, int application) {
        if (OpusManager.isNativeOpusCompatible()) {
            NativeOpusEncoderImpl encoder = NativeOpusEncoderImpl.createEncoder(sampleRate, frameSize, maxPayloadSize, application);
            if (encoder != null) {
                return encoder;
            }
            nativeOpusCompatible = false;
            Voicechat.LOGGER.warn("Failed to load native Opus encoder - Falling back to Java Opus implementation");
        }
        return new JavaOpusEncoderImpl(sampleRate, frameSize, maxPayloadSize, application);
    }

    public static OpusEncoder createEncoder(OpusEncoderMode mode) {
        int application = ServerConfig.Codec.VOIP.getOpusValue();
        if (mode != null) {
            application = switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case OpusEncoderMode.VOIP -> ServerConfig.Codec.VOIP.getOpusValue();
                case OpusEncoderMode.AUDIO -> ServerConfig.Codec.AUDIO.getOpusValue();
                case OpusEncoderMode.RESTRICTED_LOWDELAY -> ServerConfig.Codec.RESTRICTED_LOWDELAY.getOpusValue();
            };
        }
        return OpusManager.createEncoder(48000, 960, 1024, application);
    }

    public static OpusDecoder createDecoder(int sampleRate, int frameSize, int maxPayloadSize) {
        if (OpusManager.isNativeOpusCompatible()) {
            NativeOpusDecoderImpl decoder = NativeOpusDecoderImpl.createDecoder(sampleRate, frameSize, maxPayloadSize);
            if (decoder != null) {
                return decoder;
            }
            nativeOpusCompatible = false;
            Voicechat.LOGGER.warn("Failed to load native Opus decoder - Falling back to Java Opus implementation");
        }
        return new JavaOpusDecoderImpl(sampleRate, frameSize, maxPayloadSize);
    }

    public static OpusDecoder createDecoder() {
        return OpusManager.createDecoder(48000, 960, 1024);
    }

    private static boolean isOpusCompatible() {
        int actualPatch;
        String versionString = Opus.INSTANCE.opus_get_version_string();
        Matcher matcher = VERSIONING_PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            Voicechat.LOGGER.warn("Failed to parse Opus version '{}'", (Object)versionString);
            return false;
        }
        String majorGroup = matcher.group("major");
        String minorGroup = matcher.group("minor");
        String patchGroup = matcher.group("patch");
        int actualMajor = majorGroup == null ? 0 : Integer.parseInt(majorGroup);
        int actualMinor = minorGroup == null ? 0 : Integer.parseInt(minorGroup);
        int n = actualPatch = patchGroup == null ? 0 : Integer.parseInt(patchGroup);
        if (!OpusManager.isMinimum(actualMajor, actualMinor, actualPatch, 1, 1, 0)) {
            Voicechat.LOGGER.warn("Outdated Opus version detected: {}", (Object)versionString);
            return false;
        }
        Voicechat.LOGGER.info("Using Opus version '{}'", (Object)versionString);
        return true;
    }

    private static boolean isMinimum(int actualMajor, int actualMinor, int actualPatch, int major, int minor, int patch) {
        if (major > actualMajor) {
            return false;
        }
        if (major == actualMajor) {
            if (minor > actualMinor) {
                return false;
            }
            if (minor == actualMinor) {
                return patch <= actualPatch;
            }
            return true;
        }
        return true;
    }

    static {
        VERSIONING_PATTERN = Pattern.compile("^[^\\d\\.]* ?(?<major>\\d+)(?:\\.(?<minor>\\d+)(?:\\.(?<patch>\\d+)){0,1}){0,1}.*$");
    }
}

