/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.sun.jna.Platform;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.macos.PermissionCheck;
import de.maxhenkel.voicechat.macos.jna.avfoundation.AVAuthorizationStatus;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.RequestSecretPacket;
import de.maxhenkel.voicechat.net.SecretPacket;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import de.maxhenkel.voicechat.voice.client.InitializationData;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import de.maxhenkel.voicechat.voice.client.PTTKeyHandler;
import de.maxhenkel.voicechat.voice.client.RenderEvents;
import de.maxhenkel.voicechat.voice.server.Server;
import io.netty.channel.local.LocalAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class ClientManager {
    @Nullable
    private ClientVoicechat client;
    private final ClientPlayerStateManager playerStateManager = new ClientPlayerStateManager();
    private final PTTKeyHandler pttKeyHandler = new PTTKeyHandler();
    private final RenderEvents renderEvents = new RenderEvents();
    private final KeyEvents keyEvents = new KeyEvents();
    private final Minecraft minecraft = Minecraft.m_91087_();
    private static ClientManager instance;

    private ClientManager() {
        ClientCompatibilityManager.INSTANCE.onJoinWorld(this::onJoinWorld);
        ClientCompatibilityManager.INSTANCE.onDisconnect(this::onDisconnect);
        ClientCompatibilityManager.INSTANCE.onPublishServer(this::onPublishServer);
        ClientCompatibilityManager.INSTANCE.onVoiceChatConnected(connection -> {
            if (this.client != null) {
                this.client.onVoiceChatConnected((ClientVoicechatConnection)connection);
            }
        });
        ClientCompatibilityManager.INSTANCE.onVoiceChatDisconnected(() -> {
            if (this.client != null) {
                this.client.onVoiceChatDisconnected();
            }
        });
        CommonCompatibilityManager.INSTANCE.getNetManager().secretChannel.setClientListener((client, handler, packet) -> this.authenticate((SecretPacket)packet));
    }

    private void authenticate(SecretPacket secretPacket) {
        ClientPacketListener connection;
        if (this.client == null) {
            Voicechat.LOGGER.error("Received secret without a client being present");
            return;
        }
        Voicechat.LOGGER.info("Received secret");
        if (this.client.getConnection() != null) {
            ClientCompatibilityManager.INSTANCE.emitVoiceChatDisconnectedEvent();
        }
        if ((connection = this.minecraft.m_91403_()) != null) {
            try {
                SocketAddress socketAddress = ClientCompatibilityManager.INSTANCE.getSocketAddress(connection.m_6198_());
                if (socketAddress instanceof InetSocketAddress) {
                    InetSocketAddress address = (InetSocketAddress)socketAddress;
                    this.client.connect(new InitializationData(address.getHostString(), secretPacket));
                } else if (socketAddress instanceof LocalAddress) {
                    this.client.connect(new InitializationData("127.0.0.1", secretPacket));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void onJoinWorld() {
        if (this.client != null) {
            Voicechat.LOGGER.info("Disconnecting from previous connection due to server change");
            this.onDisconnect();
        }
        Voicechat.LOGGER.info("Sending secret request to the server");
        NetManager.sendToServer(new RequestSecretPacket(Voicechat.COMPATIBILITY_VERSION));
        this.client = new ClientVoicechat();
        this.checkMicrophonePermissions();
    }

    public static void sendPlayerError(String translationKey, @Nullable Exception e) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        player.m_6352_((Component)ComponentUtils.m_130748_((Component)new TextComponent(CommonCompatibilityManager.INSTANCE.getModName())).m_130940_(ChatFormatting.GREEN).m_130946_(" ").m_7220_((Component)new TranslatableComponent(translationKey).m_130940_(ChatFormatting.RED)).m_130938_(style -> {
            if (e != null) {
                return style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent(e.getMessage()).m_130940_(ChatFormatting.RED)));
            }
            return style;
        }), Util.f_137441_);
    }

    private void onDisconnect() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        ClientCompatibilityManager.INSTANCE.emitVoiceChatDisconnectedEvent();
    }

    private void onPublishServer(int port) {
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            return;
        }
        try {
            ClientVoicechatConnection connection;
            Voicechat.LOGGER.info("Changing voice chat port to {}", (Object)port);
            server.changePort(port);
            ClientVoicechat client = ClientManager.getClient();
            if (client != null && (connection = client.getConnection()) != null) {
                Voicechat.LOGGER.info("Force disconnecting due to port change");
                connection.disconnect();
            }
            NetManager.sendToServer(new RequestSecretPacket(Voicechat.COMPATIBILITY_VERSION));
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to change voice chat port: {}", (Object)e.getMessage());
        }
        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)new TranslatableComponent("message.voicechat.server_port", new Object[]{server.getPort()}));
    }

    public void checkMicrophonePermissions() {
        AVAuthorizationStatus status;
        if (!VoicechatClient.CLIENT_CONFIG.macosMicrophoneWorkaround.get().booleanValue()) {
            return;
        }
        if (Platform.isMac() && !(status = PermissionCheck.getMicrophonePermissions()).equals((Object)AVAuthorizationStatus.AUTHORIZED)) {
            ClientManager.sendPlayerError("message.voicechat.macos_no_mic_permission", null);
            Voicechat.LOGGER.warn("User hasn't granted microphone permissions: {}", (Object)status.name());
        }
    }

    @Nullable
    public static ClientVoicechat getClient() {
        return ClientManager.instance().client;
    }

    public static ClientPlayerStateManager getPlayerStateManager() {
        return ClientManager.instance().playerStateManager;
    }

    public static PTTKeyHandler getPttKeyHandler() {
        return ClientManager.instance().pttKeyHandler;
    }

    public static RenderEvents getRenderEvents() {
        return ClientManager.instance().renderEvents;
    }

    public KeyEvents getKeyEvents() {
        return this.keyEvents;
    }

    public static ClientManager instance() {
        if (instance == null) {
            instance = new ClientManager();
        }
        return instance;
    }
}

