/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.diagonalfences.api.IDiagonalBlock;
import fuzs.diagonalfences.util.EightWayDirection;
import fuzs.diagonalfences.util.math.shapes.NoneVoxelShape;
import fuzs.diagonalfences.util.math.shapes.VoxelCollection;
import fuzs.diagonalfences.util.math.shapes.VoxelUtils;
import fuzs.puzzleslib.util.PuzzlesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface IEightWayBlock
extends IDiagonalBlock {
    public static final Map<List<Float>, VoxelShape[]> DIMENSIONS_TO_SHAPE_MAP = Maps.newHashMap();
    public static final Map<EightWayDirection, BooleanProperty> DIRECTION_TO_PROPERTY_MAP = (Map)PuzzlesUtil.make((Object)Maps.newEnumMap(EightWayDirection.class), directions -> {
        directions.put(EightWayDirection.NORTH, PipeBlock.f_55148_);
        directions.put(EightWayDirection.EAST, PipeBlock.f_55149_);
        directions.put(EightWayDirection.SOUTH, PipeBlock.f_55150_);
        directions.put(EightWayDirection.WEST, PipeBlock.f_55151_);
        directions.put(EightWayDirection.NORTH_EAST, IDiagonalBlock.NORTH_EAST);
        directions.put(EightWayDirection.SOUTH_EAST, IDiagonalBlock.SOUTH_EAST);
        directions.put(EightWayDirection.SOUTH_WEST, IDiagonalBlock.SOUTH_WEST);
        directions.put(EightWayDirection.NORTH_WEST, IDiagonalBlock.NORTH_WEST);
    });

    public boolean canConnect(BlockGetter var1, BlockPos var2, BlockState var3, Direction var4);

    default public BlockState getDefaultStates(BlockState defaultState) {
        return (BlockState)((BlockState)((BlockState)((BlockState)defaultState.m_61124_((Property)IDiagonalBlock.NORTH_EAST, (Comparable)Boolean.FALSE)).m_61124_((Property)IDiagonalBlock.SOUTH_EAST, (Comparable)Boolean.FALSE)).m_61124_((Property)IDiagonalBlock.SOUTH_WEST, (Comparable)Boolean.FALSE)).m_61124_((Property)IDiagonalBlock.NORTH_WEST, (Comparable)Boolean.FALSE);
    }

    default public void fillStateContainer2(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{IDiagonalBlock.NORTH_EAST, IDiagonalBlock.SOUTH_EAST, IDiagonalBlock.SOUTH_WEST, IDiagonalBlock.NORTH_WEST});
    }

    default public int makeIndex(BlockState stateIn) {
        int index = 0;
        for (Map.Entry<EightWayDirection, BooleanProperty> entry : DIRECTION_TO_PROPERTY_MAP.entrySet()) {
            if (!((Boolean)stateIn.m_61143_((Property)entry.getValue())).booleanValue()) continue;
            index |= entry.getKey().getHorizontalIndex();
        }
        return index;
    }

    default public BlockState makeStateForPlacement(BlockState placementState, BlockGetter blockGetter, BlockPos basePos, FluidState fluidState) {
        placementState.m_61124_((Property)CrossCollisionBlock.f_52313_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        placementState = this.withDirections(EightWayDirection.getAllCardinals(), basePos, placementState, (mutablePos, newPlacementState, direction) -> this.canConnect(blockGetter, mutablePos, blockGetter.m_8055_(mutablePos), direction.convertTo().m_122424_()));
        placementState = this.withDirections(EightWayDirection.getAllIntercardinals(), basePos, placementState, (mutablePos, newPlacementState, direction) -> {
            if (!this.canConnectDiagonally(blockGetter.m_8055_(mutablePos))) return false;
            if (!Stream.of(direction.getCardinalNeighbors()).map(DIRECTION_TO_PROPERTY_MAP::get).noneMatch(arg_0 -> ((BlockState)newPlacementState).m_61143_(arg_0))) return false;
            return true;
        });
        return placementState;
    }

    default public BlockState withDirections(EightWayDirection[] directions, BlockPos basePos, BlockState placementState, DirectionStatePredicate predicate) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (EightWayDirection direction : directions) {
            Vec3i directionVec = direction.directionVec;
            mutablePos.m_122154_((Vec3i)basePos, directionVec.m_123341_(), directionVec.m_123342_(), directionVec.m_123343_());
            placementState = (BlockState)placementState.m_61124_((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)direction), (Comparable)Boolean.valueOf(predicate.test((BlockPos)mutablePos, placementState, direction)));
        }
        return placementState;
    }

    default public BlockState updatePostPlacement2(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos, BlockState newState) {
        if (facing.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL) {
            BlockPos.MutableBlockPos diagonalPos = new BlockPos.MutableBlockPos();
            for (EightWayDirection direction : EightWayDirection.convertTo(facing).getIntercardinalNeighbors()) {
                Vec3i directionVec = direction.directionVec;
                diagonalPos.m_122154_((Vec3i)currentPos, directionVec.m_123341_(), directionVec.m_123342_(), directionVec.m_123343_());
                BlockState diagonalState = level.m_8055_((BlockPos)diagonalPos);
                boolean isBlocked = false;
                for (EightWayDirection cardinal : direction.getCardinalNeighbors()) {
                    isBlocked = isBlocked || (Boolean)newState.m_61143_((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)cardinal)) != false;
                }
                newState = (BlockState)newState.m_61124_((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)direction), (Comparable)Boolean.valueOf(!isBlocked && this.canConnectDiagonally(diagonalState)));
            }
            return newState;
        }
        return null;
    }

    default public void updateDiagonalNeighbors2(BlockState state, LevelAccessor level, BlockPos pos, int flags, int recursionLeft) {
        BlockPos.MutableBlockPos diagonalPos = new BlockPos.MutableBlockPos();
        for (EightWayDirection direction : EightWayDirection.getAllIntercardinals()) {
            Vec3i directionVec = direction.directionVec;
            diagonalPos.m_122154_((Vec3i)pos, directionVec.m_123341_(), directionVec.m_123342_(), directionVec.m_123343_());
            BlockState diagonalState = level.m_8055_((BlockPos)diagonalPos);
            if (!(diagonalState.m_60734_() instanceof IEightWayBlock) || !((IEightWayBlock)diagonalState.m_60734_()).canConnectDiagonally()) continue;
            boolean isBlocked = false;
            for (EightWayDirection cardinal : direction.getOpposite().getCardinalNeighbors()) {
                isBlocked = isBlocked || (Boolean)diagonalState.m_61143_((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)cardinal)) != false;
            }
            BlockState newState = (BlockState)diagonalState.m_61124_((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)direction.getOpposite()), (Comparable)Boolean.valueOf(!isBlocked && ((IEightWayBlock)diagonalState.m_60734_()).canConnectDiagonally(level.m_8055_(pos))));
            Block.m_49908_((BlockState)diagonalState, (BlockState)newState, (LevelAccessor)level, (BlockPos)diagonalPos, (int)flags, (int)recursionLeft);
        }
    }

    default public VoxelShape[] getShapes(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        ArrayList dimensions = Lists.newArrayList((Object[])new Float[]{Float.valueOf(nodeWidth), Float.valueOf(extensionWidth), Float.valueOf(nodeHeight), Float.valueOf(extensionBottom), Float.valueOf(extensionHeight)});
        return DIMENSIONS_TO_SHAPE_MAP.computeIfAbsent(dimensions, dimension -> this.makeDiagonalShapes(nodeWidth, extensionWidth, nodeHeight, extensionBottom, extensionHeight));
    }

    default public VoxelCollection[] makeDiagonalShapes(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        float nodeStart = 8.0f - nodeWidth;
        float nodeEnd = 8.0f + nodeWidth;
        float extensionStart = 8.0f - extensionWidth;
        float extensionEnd = 8.0f + extensionWidth;
        VoxelShape nodeShape = Block.m_49796_((double)nodeStart, (double)0.0, (double)nodeStart, (double)nodeEnd, (double)nodeHeight, (double)nodeEnd);
        Vec3[] sideShape = new Vec3[]{new Vec3((double)extensionStart, (double)extensionBottom, 0.0), new Vec3((double)extensionEnd, (double)extensionHeight, (double)extensionStart)};
        VoxelShape[] verticalShapes = (VoxelShape[])Stream.of(EightWayDirection.getAllCardinals()).map(direction -> direction.transform(sideShape)).map(VoxelUtils::makeCuboidShape).toArray(VoxelShape[]::new);
        VoxelShape[] diagonalShapes = (VoxelShape[])Stream.of(EightWayDirection.getAllIntercardinals()).map(direction -> this.getDiagonalShape(extensionWidth, extensionBottom, extensionHeight, (EightWayDirection)((Object)direction))).toArray(VoxelShape[]::new);
        VoxelShape[] sideShapes = new VoxelShape[]{verticalShapes[2], verticalShapes[3], verticalShapes[0], verticalShapes[1], diagonalShapes[2], diagonalShapes[3], diagonalShapes[0], diagonalShapes[1]};
        return this.constructStateShapes(nodeShape, sideShapes);
    }

    default public VoxelCollection[] constructStateShapes(VoxelShape nodeShape, VoxelShape[] directionalShapes) {
        VoxelCollection[] stateShapes = new VoxelCollection[(int)Math.pow(2.0, directionalShapes.length)];
        for (int i = 0; i < stateShapes.length; ++i) {
            stateShapes[i] = new VoxelCollection(nodeShape);
            for (int j = 0; j < directionalShapes.length; ++j) {
                if ((i & 1 << j) == 0) continue;
                stateShapes[i].addVoxelShape(directionalShapes[j]);
            }
        }
        return stateShapes;
    }

    default public VoxelShape getDiagonalShape(float extensionWidth, float extensionBottom, float extensionHeight, EightWayDirection direction) {
        VoxelShape collisionShape = this.getDiagonalCollisionShape(extensionWidth, extensionBottom, extensionHeight, direction);
        extensionWidth = (float)Math.sqrt(extensionWidth * extensionWidth * 2.0f);
        float diagonalSide = 0.70710677f * extensionWidth;
        Vec3[] corners = VoxelUtils.createVectorArray(Float.valueOf(-diagonalSide), Float.valueOf(extensionHeight), Float.valueOf(diagonalSide), Float.valueOf(-diagonalSide + 8.0f), Float.valueOf(extensionHeight), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(-diagonalSide), Float.valueOf(extensionBottom), Float.valueOf(diagonalSide), Float.valueOf(-diagonalSide + 8.0f), Float.valueOf(extensionBottom), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(diagonalSide), Float.valueOf(extensionHeight), Float.valueOf(-diagonalSide), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(extensionHeight), Float.valueOf(-diagonalSide + 8.0f), Float.valueOf(diagonalSide), Float.valueOf(extensionBottom), Float.valueOf(-diagonalSide), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(extensionBottom), Float.valueOf(-diagonalSide + 8.0f));
        Vec3[] edges = VoxelUtils.create12Edges(corners);
        if (direction.directionVec.m_123341_() != 1) {
            edges = VoxelUtils.flipX(edges);
        }
        if (direction.directionVec.m_123343_() != 1) {
            edges = VoxelUtils.flipZ(edges);
        }
        return new NoneVoxelShape(collisionShape, VoxelUtils.scaleDown(edges));
    }

    default public VoxelShape getDiagonalCollisionShape(float extensionWidth, float extensionBottom, float extensionHeight, EightWayDirection direction) {
        VoxelShape collisionShape = Shapes.m_83040_();
        for (int i = 0; i < 8; ++i) {
            Vec3i directionVec = direction.directionVec;
            int posX = directionVec.m_123341_() > 0 ? i : 16 - i;
            int posZ = directionVec.m_123343_() > 0 ? i : 16 - i;
            VoxelShape cuboidShape = Block.m_49796_((double)((float)posX - extensionWidth), (double)extensionBottom, (double)((float)posZ - extensionWidth), (double)((float)posX + extensionWidth), (double)extensionHeight, (double)((float)posZ + extensionWidth));
            collisionShape = Shapes.m_83110_((VoxelShape)collisionShape, (VoxelShape)cuboidShape);
        }
        return collisionShape;
    }

    @FunctionalInterface
    public static interface DirectionStatePredicate {
        public boolean test(BlockPos var1, BlockState var2, EightWayDirection var3);
    }
}

