/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.mixin;

import fuzs.diagonalfences.DiagonalFences;
import fuzs.diagonalfences.block.IEightWayBlock;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FenceBlock.class})
public abstract class FenceBlockMixin
extends CrossCollisionBlock
implements IEightWayBlock {
    private boolean hasProperties;
    private Object2IntMap<BlockState> statePaletteMap;

    public FenceBlockMixin(float nodeWidth, float extensionWidth, float nodeHeight, float extensionHeight, float collisionY, BlockBehaviour.Properties properties) {
        super(nodeWidth, extensionWidth, nodeHeight, extensionHeight, collisionY, properties);
    }

    protected VoxelShape[] m_52326_(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        if (this.hasProperties()) {
            return this.getShapes(nodeWidth, extensionWidth, nodeHeight, extensionBottom, extensionHeight);
        }
        return super.m_52326_(nodeWidth, extensionWidth, nodeHeight, extensionBottom, extensionHeight);
    }

    protected int m_52363_(BlockState state) {
        if (this.hasProperties()) {
            if (this.statePaletteMap == null) {
                this.statePaletteMap = new Object2IntOpenHashMap();
            }
            return this.statePaletteMap.computeIfAbsent((Object)state, this::makeIndex);
        }
        return super.m_52363_(state);
    }

    public void m_7742_(BlockState state, LevelAccessor world, BlockPos pos, int flags, int recursionLeft) {
        if (this.canConnectDiagonally()) {
            this.updateDiagonalNeighbors2(state, world, pos, flags, recursionLeft);
        }
    }

    @Shadow
    public abstract boolean m_53329_(BlockState var1, boolean var2, Direction var3);

    @Shadow
    private boolean m_153254_(BlockState state) {
        throw new IllegalStateException();
    }

    @Shadow
    protected abstract void m_7926_(StateDefinition.Builder<Block, BlockState> var1);

    @Override
    public boolean hasProperties() {
        return this.hasProperties;
    }

    @Override
    public boolean canConnect(BlockGetter blockGetter, BlockPos position, BlockState state, Direction direction) {
        return this.m_53329_(state, state.m_60783_(blockGetter, position, direction), direction);
    }

    @Override
    public boolean canConnectDiagonally() {
        ITagManager blockTags = Objects.requireNonNull(ForgeRegistries.BLOCKS.tags(), "ITagManager missing for Block registry?!");
        return this.hasProperties() && !blockTags.getTag(DiagonalFences.NON_DIAGONAL_FENCES_TAG).contains((Object)this);
    }

    @Override
    public boolean canConnectDiagonally(BlockState blockstate) {
        Block block = blockstate.m_60734_();
        return block instanceof FenceBlock && ((IEightWayBlock)block).canConnectDiagonally() && this.m_153254_(blockstate);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void diagonalfences_init(BlockBehaviour.Properties properties, CallbackInfo callbackInfo) {
        if (this.hasProperties()) {
            this.m_49959_(this.getDefaultStates(this.m_49966_()));
        }
    }

    @Inject(method={"createBlockStateDefinition"}, at={@At(value="TAIL")})
    protected void diagonalfences_createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo callbackInfo) {
        this.hasProperties = true;
        this.fillStateContainer2(builder);
    }

    @Inject(method={"getStateForPlacement"}, at={@At(value="HEAD")}, cancellable=true)
    public void diagonalfences_getStateForPlacement(BlockPlaceContext context, CallbackInfoReturnable<BlockState> callbackInfo) {
        if (this.canConnectDiagonally()) {
            Level iblockreader = context.m_43725_();
            BlockPos basePos = context.m_8083_();
            FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
            BlockState placementState = super.m_5573_(context);
            placementState = this.makeStateForPlacement(placementState, (BlockGetter)iblockreader, basePos, fluidState);
            callbackInfo.setReturnValue((Object)placementState);
        }
    }

    @Inject(method={"updateShape"}, at={@At(value="TAIL")}, cancellable=true)
    public void diagonalfences_updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos, CallbackInfoReturnable<BlockState> callbackInfo) {
        BlockState returnState;
        if (this.canConnectDiagonally() && (returnState = this.updatePostPlacement2(state, facing, facingState, level, currentPos, facingPos, (BlockState)callbackInfo.getReturnValue())) != null) {
            callbackInfo.setReturnValue((Object)returnState);
        }
    }
}

