/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.TriPredicate;
import vazkii.patchouli.common.multiblock.AbstractMultiblock;
import vazkii.patchouli.common.multiblock.SimulateResultImpl;
import vazkii.patchouli.common.multiblock.StateMatcher;
import vazkii.patchouli.common.multiblock.StringStateMatcher;
import vazkii.patchouli.common.util.RotationUtil;

public class DenseMultiblock
extends AbstractMultiblock {
    private final String[][] pattern;
    private IStateMatcher[][][] stateTargets;
    private final Vec3i size;

    public DenseMultiblock(String[][] pattern, Map<Character, IStateMatcher> targets) {
        this.pattern = pattern;
        this.size = this.build(targets, DenseMultiblock.getPatternDimensions(pattern));
    }

    public DenseMultiblock(String[][] pattern, Object ... targets) {
        this.pattern = pattern;
        this.size = this.build(DenseMultiblock.targetsToMatchers(targets), DenseMultiblock.getPatternDimensions(pattern));
    }

    @Override
    public Pair<BlockPos, Collection<IMultiblock.SimulateResult>> simulate(Level world, BlockPos anchor, Rotation rotation, boolean forView) {
        BlockPos disp = forView ? new BlockPos(-this.viewOffX, -this.viewOffY + 1, -this.viewOffZ).m_7954_(rotation) : new BlockPos(-this.offX, -this.offY, -this.offZ).m_7954_(rotation);
        BlockPos origin = anchor.m_141952_((Vec3i)disp);
        ArrayList<SimulateResultImpl> ret = new ArrayList<SimulateResultImpl>();
        for (int x = 0; x < this.size.m_123341_(); ++x) {
            for (int y = 0; y < this.size.m_123342_(); ++y) {
                for (int z = 0; z < this.size.m_123343_(); ++z) {
                    BlockPos currDisp = new BlockPos(x, y, z).m_7954_(rotation);
                    BlockPos actionPos = origin.m_141952_((Vec3i)currDisp);
                    char currC = this.pattern[y][x].charAt(z);
                    ret.add(new SimulateResultImpl(actionPos, this.stateTargets[x][y][z], Character.valueOf(currC)));
                }
            }
        }
        return Pair.of((Object)origin, ret);
    }

    @Override
    public boolean test(Level world, BlockPos start, int x, int y, int z, Rotation rotation) {
        this.setWorld(world);
        if (x < 0 || y < 0 || z < 0 || x >= this.size.m_123341_() || y >= this.size.m_123342_() || z >= this.size.m_123343_()) {
            return false;
        }
        BlockPos checkPos = start.m_141952_((Vec3i)new BlockPos(x, y, z).m_7954_(RotationUtil.fixHorizontal(rotation)));
        TriPredicate<BlockGetter, BlockPos, BlockState> pred = this.stateTargets[x][y][z].getStatePredicate();
        BlockState state = world.m_8055_(checkPos).m_60717_(rotation);
        return pred.test((BlockGetter)world, checkPos, state);
    }

    private static Map<Character, IStateMatcher> targetsToMatchers(Object ... targets) {
        if (targets.length % 2 == 1) {
            throw new IllegalArgumentException("Illegal argument length for targets array " + targets.length);
        }
        HashMap<Character, IStateMatcher> stateMap = new HashMap<Character, IStateMatcher>();
        for (int i = 0; i < targets.length / 2; ++i) {
            IStateMatcher state;
            char c = ((Character)targets[i * 2]).charValue();
            Object o = targets[i * 2 + 1];
            if (o instanceof Block) {
                state = StateMatcher.fromBlockLoose((Block)o);
            } else if (o instanceof BlockState) {
                state = StateMatcher.fromState((BlockState)o);
            } else if (o instanceof String) {
                try {
                    state = StringStateMatcher.fromString((String)o);
                }
                catch (CommandSyntaxException e) {
                    throw new RuntimeException(e);
                }
            } else if (o instanceof IStateMatcher) {
                state = (IStateMatcher)o;
            } else {
                throw new IllegalArgumentException("Invalid target " + o);
            }
            stateMap.put(Character.valueOf(c), state);
        }
        if (!stateMap.containsKey(Character.valueOf('_'))) {
            stateMap.put(Character.valueOf('_'), StateMatcher.ANY);
        }
        if (!stateMap.containsKey(Character.valueOf(' '))) {
            stateMap.put(Character.valueOf(' '), StateMatcher.AIR);
        }
        if (!stateMap.containsKey(Character.valueOf('0'))) {
            stateMap.put(Character.valueOf('0'), StateMatcher.AIR);
        }
        return stateMap;
    }

    private Vec3i build(Map<Character, IStateMatcher> stateMap, Vec3i dimensions) {
        boolean foundCenter = false;
        this.stateTargets = new IStateMatcher[dimensions.m_123341_()][dimensions.m_123342_()][dimensions.m_123343_()];
        for (int y = 0; y < dimensions.m_123342_(); ++y) {
            for (int x = 0; x < dimensions.m_123341_(); ++x) {
                for (int z = 0; z < dimensions.m_123343_(); ++z) {
                    char c = this.pattern[y][x].charAt(z);
                    if (!stateMap.containsKey(Character.valueOf(c))) {
                        throw new IllegalArgumentException("Character " + c + " isn't mapped");
                    }
                    IStateMatcher matcher = stateMap.get(Character.valueOf(c));
                    if (c == '0') {
                        if (foundCenter) {
                            throw new IllegalArgumentException("A structure can't have two centers");
                        }
                        foundCenter = true;
                        this.offX = x;
                        this.offY = dimensions.m_123342_() - y - 1;
                        this.offZ = z;
                        this.setViewOffset();
                    }
                    this.stateTargets[x][dimensions.m_123342_() - y - 1][z] = matcher;
                }
            }
        }
        if (!foundCenter) {
            throw new IllegalArgumentException("A structure can't have no center");
        }
        return dimensions;
    }

    private static Vec3i getPatternDimensions(String[][] pattern) {
        int expectedLenX = -1;
        int expectedLenZ = -1;
        for (String[] arr : pattern) {
            if (expectedLenX == -1) {
                expectedLenX = arr.length;
            }
            if (arr.length != expectedLenX) {
                throw new IllegalArgumentException("Inconsistent array length. Expected" + expectedLenX + ", got " + arr.length);
            }
            for (String s : arr) {
                if (expectedLenZ == -1) {
                    expectedLenZ = s.length();
                }
                if (s.length() == expectedLenZ) continue;
                throw new IllegalArgumentException("Inconsistent array length. Expected" + expectedLenX + ", got " + arr.length);
            }
        }
        return new Vec3i(expectedLenX, pattern.length, expectedLenZ);
    }

    public BlockState m_8055_(BlockPos pos) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (x < 0 || y < 0 || z < 0 || x >= this.size.m_123341_() || y >= this.size.m_123342_() || z >= this.size.m_123343_()) {
            return Blocks.f_50016_.m_49966_();
        }
        long ticks = this.world != null ? this.world.m_46467_() : 0L;
        return this.stateTargets[x][y][z].getDisplayedState(ticks);
    }

    @Override
    public Vec3i getSize() {
        return this.size;
    }

    @Override
    public int m_141928_() {
        return 255;
    }

    @Override
    public int m_141937_() {
        return 0;
    }
}

