/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.forge.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.forge.network.ForgeNetworkHandler;

public class ForgeMessageOpenBookGui {
    private final ResourceLocation book;
    @Nullable
    private final ResourceLocation entry;
    private final int page;

    public ForgeMessageOpenBookGui(ResourceLocation book, @Nullable ResourceLocation entry, int page) {
        this.book = book;
        this.entry = entry;
        this.page = page;
    }

    public static ForgeMessageOpenBookGui decode(FriendlyByteBuf buf) {
        ResourceLocation book = buf.m_130281_();
        String tmp = buf.m_130277_();
        ResourceLocation entry = tmp.isEmpty() ? null : ResourceLocation.m_135820_((String)tmp);
        int page = buf.m_130242_();
        return new ForgeMessageOpenBookGui(book, entry, page);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.book);
        buf.m_130070_(this.entry == null ? "" : this.entry.toString());
        buf.m_130130_(this.page);
    }

    public static void send(ServerPlayer player, ResourceLocation book, @Nullable ResourceLocation entry, int page) {
        ForgeNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ForgeMessageOpenBookGui(book, entry, page));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientBookRegistry.INSTANCE.displayBookGui(this.book, this.entry, this.page));
        ctx.get().setPacketHandled(true);
    }
}

