/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.chiseling.eligibility;

import mod.chiselsandbits.api.IChiselsAndBitsAPI;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityAnalysisResult;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public interface IEligibilityManager {
    public static IEligibilityManager getInstance() {
        return IChiselsAndBitsAPI.getInstance().getEligibilityManager();
    }

    default public boolean canBeChiseled(@NotNull BlockInformation blockInformation) {
        return this.analyse(blockInformation).canBeChiseled() || this.analyse(blockInformation).isAlreadyChiseled();
    }

    default public boolean canBeChiseled(@NotNull BlockState state) {
        return this.analyse(state).canBeChiseled() || this.analyse(state).isAlreadyChiseled();
    }

    default public boolean canBeChiseled(@NotNull Block block) {
        return this.analyse(block.m_49966_()).canBeChiseled();
    }

    default public boolean canBeChiseled(@NotNull ItemLike provider) {
        return this.analyse(provider).canBeChiseled();
    }

    public IEligibilityAnalysisResult analyse(@NotNull BlockInformation var1);

    default public IEligibilityAnalysisResult analyse(@NotNull BlockState state) {
        return this.analyse(new BlockInformation(state));
    }

    default public IEligibilityAnalysisResult analyse(@NotNull Block block) {
        return this.analyse(block.m_49966_());
    }

    public IEligibilityAnalysisResult analyse(@NotNull ItemLike var1);
}

