/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block.entities.storage;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.DataResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.util.BlockStateSerializationUtils;
import mod.chiselsandbits.api.util.INBTSerializable;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SimpleStateEntryPalette
implements IPacketBufferSerializable,
INBTSerializable<ListTag> {
    private final List<Entry> paletteEntries = Collections.synchronizedList(Lists.newArrayList());
    private final BiMap<BlockInformation, Entry> paletteMap = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
    private final IntConsumer onNewSizeAddedConsumer;
    private final Consumer<Map<Integer, Integer>> onPaletteIndexChanged;

    public SimpleStateEntryPalette(IntConsumer onNewSizeAddedConsumer, Consumer<Map<Integer, Integer>> onPaletteIndexChanged) {
        this.onNewSizeAddedConsumer = onNewSizeAddedConsumer;
        this.onPaletteIndexChanged = onPaletteIndexChanged;
        this.clear();
    }

    public SimpleStateEntryPalette(IntConsumer onPaletteResize, Consumer<Map<Integer, Integer>> onPaletteIndexChanged, SimpleStateEntryPalette palette) {
        this.onNewSizeAddedConsumer = onPaletteResize;
        this.onPaletteIndexChanged = onPaletteIndexChanged;
        this.paletteEntries.addAll(palette.paletteEntries);
        this.paletteMap.putAll(palette.paletteMap);
    }

    @Override
    public ListTag serializeNBT() {
        return this.paletteEntries.stream().map(INBTSerializable::serializeNBT).collect(Collectors.toCollection(ListTag::new));
    }

    @Override
    public void deserializeNBT(ListTag nbt) {
        int currentSize = this.paletteEntries.size();
        this.paletteMap.clear();
        this.paletteEntries.clear();
        if (nbt.m_7264_() == 8) {
            nbt.stream().filter(StringTag.class::isInstance).map(StringTag.class::cast).map(Entry::new).forEach(this.paletteEntries::add);
        } else if (nbt.m_7264_() == 10) {
            nbt.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).map(Entry::new).forEach(this.paletteEntries::add);
        }
        this.paletteEntries.forEach(entry -> this.paletteMap.put((Object)entry.get(), entry));
        if (this.paletteEntries.size() == 0) {
            this.clear();
        }
        if (currentSize != this.paletteEntries.size()) {
            this.onNewSizeAddedConsumer.accept(this.paletteEntries.size());
        }
    }

    @Override
    public void serializeInto(@NotNull FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130130_(this.paletteEntries.size());
        this.paletteEntries.forEach(entry -> entry.serializeInto(packetBuffer));
    }

    @Override
    public void deserializeFrom(@NotNull FriendlyByteBuf packetBuffer) {
        int currentSize = this.paletteEntries.size();
        this.paletteEntries.clear();
        this.paletteMap.clear();
        int newCount = packetBuffer.m_130242_();
        for (int i = 0; i < newCount; ++i) {
            this.paletteEntries.add(new Entry(packetBuffer));
        }
        this.paletteEntries.forEach(entry -> this.paletteMap.put((Object)entry.get(), entry));
        if (this.paletteEntries.size() == 0) {
            this.clear();
        }
        if (currentSize != this.paletteEntries.size()) {
            this.onNewSizeAddedConsumer.accept(this.paletteEntries.size());
        }
    }

    public int getIndex(BlockInformation state) {
        if (this.paletteMap.containsKey((Object)state)) {
            Entry entry = (Entry)this.paletteMap.get((Object)state);
            return this.paletteEntries.indexOf(entry);
        }
        Entry newEntry = new Entry(state);
        this.paletteMap.put((Object)state, (Object)newEntry);
        this.paletteEntries.add(newEntry);
        this.onNewSizeAddedConsumer.accept(this.paletteEntries.size());
        return this.paletteEntries.size() - 1;
    }

    public BlockInformation getBlockState(int blockStateId) {
        if (blockStateId < 0 || blockStateId >= this.paletteEntries.size()) {
            return this.getBlockState(0);
        }
        return this.paletteEntries.get(blockStateId).get();
    }

    public void sanitize(Collection<BlockInformation> toRemove) {
        List<Entry> toRemoveList = toRemove.stream().map(arg_0 -> this.paletteMap.get(arg_0)).toList();
        Map remainingPreRemoveIndexMap = this.paletteEntries.stream().filter(entry -> !toRemoveList.contains(entry)).collect(Collectors.toMap(Function.identity(), this.paletteEntries::indexOf));
        this.paletteEntries.removeAll(toRemoveList);
        toRemove.forEach(arg_0 -> this.paletteMap.remove(arg_0));
        Map remainingPostRemoveIndexMap = remainingPreRemoveIndexMap.keySet().stream().collect(Collectors.toMap(Function.identity(), this.paletteEntries::indexOf));
        Map<Integer, Integer> indexAlterationMap = remainingPreRemoveIndexMap.keySet().stream().filter(e -> !Objects.equals(remainingPreRemoveIndexMap.get(e), remainingPostRemoveIndexMap.get(e))).collect(Collectors.toMap(remainingPreRemoveIndexMap::get, remainingPostRemoveIndexMap::get));
        this.onPaletteIndexChanged.accept(indexAlterationMap);
        this.onNewSizeAddedConsumer.accept(this.paletteEntries.size());
    }

    public void clear() {
        this.paletteEntries.clear();
        this.paletteMap.clear();
        this.getIndex(new BlockInformation(Blocks.f_50016_.m_49966_()));
    }

    public List<BlockInformation> getStates() {
        return this.paletteMap.keySet().stream().toList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleStateEntryPalette)) {
            return false;
        }
        SimpleStateEntryPalette that = (SimpleStateEntryPalette)o;
        return this.paletteEntries.equals(that.paletteEntries);
    }

    public int hashCode() {
        return this.paletteEntries.hashCode();
    }

    public String toString() {
        return "SimpleStateEntryPalette{paletteEntries=" + this.paletteEntries + "}";
    }

    private static final class Entry
    implements IPacketBufferSerializable,
    INBTSerializable<CompoundTag> {
        private BlockInformation outwardFacingState;
        private CompoundTag rawSpec;

        private Entry(BlockInformation newState) {
            this.outwardFacingState = newState;
            this.rawSpec = newState.serializeNBT();
        }

        private Entry(StringTag tag) {
            this.deserializeNBT(tag);
        }

        private Entry(CompoundTag tag) {
            this.deserializeNBT(tag);
        }

        private Entry(FriendlyByteBuf buffer) {
            this.deserializeFrom(buffer);
        }

        @Override
        public void deserializeNBT(StringTag nbt) {
            String rawSpecString = nbt.m_7916_();
            DataResult<BlockState> result = BlockStateSerializationUtils.deserialize(rawSpecString);
            this.outwardFacingState = new BlockInformation(result.result().orElseGet(() -> ((Block)Blocks.f_50016_).m_49966_()));
            this.rawSpec = this.outwardFacingState.serializeNBT();
        }

        @Override
        public CompoundTag serializeNBT() {
            return this.rawSpec.m_6426_();
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            this.rawSpec = nbt;
            this.outwardFacingState = new BlockInformation(nbt);
        }

        @Override
        public void serializeInto(@NotNull FriendlyByteBuf packetBuffer) {
            this.outwardFacingState.serializeInto(packetBuffer);
        }

        @Override
        public void deserializeFrom(@NotNull FriendlyByteBuf packetBuffer) {
            this.outwardFacingState = new BlockInformation(packetBuffer);
            this.rawSpec = this.outwardFacingState.serializeNBT();
        }

        public BlockInformation get() {
            return this.outwardFacingState;
        }
    }
}

