/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhood;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhoodBuilder;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockBakedModelManager {
    private static final ChiseledBlockBakedModelManager INSTANCE = new ChiseledBlockBakedModelManager();
    private final SimpleMaxSizedCache<Key, ChiseledBlockBakedModel> cache = new SimpleMaxSizedCache(() -> IClientConfiguration.getInstance().getModelCacheSize().get() * (long)RenderType.m_110506_().size());

    private ChiseledBlockBakedModelManager() {
    }

    public static ChiseledBlockBakedModelManager getInstance() {
        return INSTANCE;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public Optional<ChiseledBlockBakedModel> get(IMultiStateItemStack multiStateItemStack, ChiselRenderType renderType) {
        try (IProfilerSection ignored = ProfilingManager.getInstance().withSection("Item based chiseled block model");){
            Optional<ChiseledBlockBakedModel> optional = Optional.of(this.get(multiStateItemStack, multiStateItemStack.getStatistics().getPrimaryState(), renderType, null, null, BlockPos.f_121853_));
            return optional;
        }
    }

    public ChiseledBlockBakedModel get(IAreaAccessor accessor, BlockInformation primaryState, ChiselRenderType renderType) {
        return this.get(accessor, primaryState, renderType, null, null, BlockPos.f_121853_);
    }

    public ChiseledBlockBakedModel get(IAreaAccessor accessor, BlockInformation primaryState, ChiselRenderType renderType, @Nullable Function<Direction, BlockInformation> neighborhoodBlockInformationProvider, @Nullable Function<Direction, IAreaAccessor> neighborhoodAreaAccessorProvider, @NotNull BlockPos position) {
        try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Block based chiseled block model");){
            long primaryStateRenderSeed = primaryState.getBlockState().m_60726_(position);
            Key key = new Key(accessor.createNewShapeIdentifier(), primaryState, renderType, IBlockNeighborhoodBuilder.getInstance().build(neighborhoodBlockInformationProvider, neighborhoodAreaAccessorProvider), primaryStateRenderSeed);
            ChiseledBlockBakedModel chiseledBlockBakedModel = this.cache.get(key, () -> {
                try (IProfilerSection ignored3 = ProfilingManager.getInstance().withSection("Cache mis");){
                    ChiseledBlockBakedModel chiseledBlockBakedModel = new ChiseledBlockBakedModel(primaryState, renderType, accessor, targetOffset -> {
                        IAreaAccessor neighborAccessor;
                        Vec3 nominalTargetOffset = Vec3.f_82478_.m_82549_(targetOffset);
                        BlockPos nominalTargetBlockOffset = new BlockPos(nominalTargetOffset);
                        Vec3 inBlockOffset = nominalTargetOffset.m_82546_(Vec3.m_82528_((Vec3i)nominalTargetBlockOffset));
                        Vec3 inBlockOffsetTarget = VectorUtils.makePositive(inBlockOffset);
                        Direction offsetDirection = Direction.m_122372_((float)nominalTargetBlockOffset.m_123341_(), (float)nominalTargetBlockOffset.m_123342_(), (float)nominalTargetBlockOffset.m_123343_());
                        if (targetOffset.m_7096_() >= 0.0 && targetOffset.m_7096_() < 1.0 && targetOffset.m_7098_() >= 0.0 && targetOffset.m_7098_() < 1.0 && targetOffset.m_7094_() >= 0.0 && targetOffset.m_7094_() < 1.0) {
                            neighborAccessor = accessor;
                        } else {
                            IAreaAccessor iAreaAccessor = neighborAccessor = neighborhoodAreaAccessorProvider != null ? (IAreaAccessor)neighborhoodAreaAccessorProvider.apply(offsetDirection) : null;
                        }
                        if (neighborAccessor != null) {
                            return neighborAccessor.getInAreaTarget(inBlockOffsetTarget).map(IStateEntryInfo::getBlockInformation).orElse(BlockInformation.AIR);
                        }
                        return neighborhoodBlockInformationProvider != null ? (BlockInformation)neighborhoodBlockInformationProvider.apply(offsetDirection) : BlockInformation.AIR;
                    }, primaryStateRenderSeed);
                    return chiseledBlockBakedModel;
                }
            });
            return chiseledBlockBakedModel;
        }
    }

    private static final class Key {
        private final IAreaShapeIdentifier identifier;
        private final BlockInformation primaryState;
        private final ChiselRenderType renderType;
        private final IBlockNeighborhood neighborhood;
        private final long renderSeed;

        private Key(IAreaShapeIdentifier identifier, BlockInformation primaryState, ChiselRenderType renderType, IBlockNeighborhood neighborhood, long renderSeed) {
            this.identifier = identifier;
            this.primaryState = primaryState;
            this.renderType = renderType;
            this.neighborhood = neighborhood;
            this.renderSeed = renderSeed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (this.renderSeed != key.renderSeed) {
                return false;
            }
            if (!Objects.equals(this.identifier, key.identifier)) {
                return false;
            }
            if (!Objects.equals(this.primaryState, key.primaryState)) {
                return false;
            }
            if (this.renderType != key.renderType) {
                return false;
            }
            return Objects.equals(this.neighborhood, key.neighborhood);
        }

        public int hashCode() {
            int result = this.identifier != null ? this.identifier.hashCode() : 0;
            result = 31 * result + (this.primaryState != null ? this.primaryState.hashCode() : 0);
            result = 31 * result + (this.renderType != null ? this.renderType.hashCode() : 0);
            result = 31 * result + (this.neighborhood != null ? this.neighborhood.hashCode() : 0);
            result = 31 * result + (int)(this.renderSeed ^ this.renderSeed >>> 32);
            return result;
        }
    }
}

