/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.platform.configuration;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.chiselsandbits.platforms.core.config.IConfigurationBuilder;
import mod.chiselsandbits.platforms.core.dist.DistExecutor;
import mod.chiselsandbits.utils.LanguageHandler;
import net.minecraft.locale.Language;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeDelegateConfigurationBuilder
implements IConfigurationBuilder {
    private final Consumer<ForgeConfigSpec> specConsumer;
    private final Consumer<String> keyConsumer;
    private final ForgeConfigSpec.Builder builder;
    private final Set<String> keys = Sets.newConcurrentHashSet();

    public ForgeDelegateConfigurationBuilder(Consumer<ForgeConfigSpec> specConsumer, Consumer<String> keyConsumer) {
        this.specConsumer = specConsumer;
        this.keyConsumer = keyConsumer;
        this.builder = new ForgeConfigSpec.Builder();
    }

    @Override
    public Supplier<Boolean> defineBoolean(String key, boolean defaultValue) {
        this.setCommentAndTranslation(key);
        return () -> ((ForgeConfigSpec.BooleanValue)this.builder.define(key, defaultValue)).get();
    }

    @Override
    public <T> Supplier<List<? extends T>> defineList(String key, List<T> defaultValue, Class<T> containedType) {
        this.setCommentAndTranslation(key);
        if (containedType != Float.class) {
            return () -> ((ForgeConfigSpec.ConfigValue)this.builder.defineList(key, defaultValue, t -> true)).get();
        }
        List<Double> defaultValueAsDoubles = defaultValue.stream().map(f -> ((Float)f).doubleValue()).toList();
        ForgeConfigSpec.ConfigValue doubleListValue = this.builder.defineList(key, defaultValueAsDoubles, t -> t instanceof Double);
        return () -> ((List)doubleListValue.get()).stream().map(d -> containedType.cast(Float.valueOf(d.floatValue()))).toList();
    }

    @Override
    public Supplier<Vector4f> defineVector4f(String key, Vector4f defaultValue) {
        this.setCommentAndTranslation(key);
        ArrayList defaultValueList = Lists.newArrayList((Object[])new Double[]{defaultValue.m_123601_(), defaultValue.m_123615_(), defaultValue.m_123616_(), defaultValue.m_123617_()});
        ForgeConfigSpec.ConfigValue doubleListValue = this.builder.defineList(key, (List)defaultValueList, t -> t instanceof Double);
        return () -> {
            List list = (List)doubleListValue.get();
            return new Vector4f(((Double)list.get(0)).floatValue(), ((Double)list.get(1)).floatValue(), ((Double)list.get(2)).floatValue(), ((Double)list.get(3)).floatValue());
        };
    }

    @Override
    public Supplier<String> defineString(String key, String defaultValue) {
        this.setCommentAndTranslation(key);
        return () -> ((ForgeConfigSpec.ConfigValue)this.builder.define(key, (Object)defaultValue)).get();
    }

    @Override
    public Supplier<Long> defineLong(String key, long defaultValue, long minValue, long maxValue) {
        this.setCommentAndTranslation(key);
        return () -> ((ForgeConfigSpec.LongValue)this.builder.defineInRange(key, defaultValue, minValue, maxValue)).get();
    }

    @Override
    public Supplier<Integer> defineInteger(String key, int defaultValue, int minValue, int maxValue) {
        this.setCommentAndTranslation(key);
        return () -> ((ForgeConfigSpec.IntValue)this.builder.defineInRange(key, defaultValue, minValue, maxValue)).get();
    }

    @Override
    public Supplier<Double> defineDouble(String key, double defaultValue, double minValue, double maxValue) {
        this.setCommentAndTranslation(key);
        return () -> ((ForgeConfigSpec.DoubleValue)this.builder.defineInRange(key, defaultValue, minValue, maxValue)).get();
    }

    @Override
    public <T extends Enum<T>> Supplier<T> defineEnum(String key, T defaultValue) {
        this.setCommentAndTranslation(key);
        return () -> ((ForgeConfigSpec.EnumValue)this.builder.defineEnum(key, defaultValue)).get();
    }

    @Override
    public void setup() {
        this.keys.forEach(this.keyConsumer);
        this.specConsumer.accept(this.builder.build());
    }

    private void setCommentAndTranslation(String unprocessedKey) {
        String key = String.format("mod.%s.config.%s.comment", "chiselsandbits", unprocessedKey);
        this.keys.add(key);
        this.builder.comment(ForgeDelegateConfigurationBuilder.translateToLocal(key));
    }

    public static String translateToLocal(String key) {
        return (String)DistExecutor.unsafeRunForDist(() -> () -> {
            String translated = Language.m_128107_().m_6834_(key);
            if (translated.equals(key)) {
                return LanguageHandler.translateKey(key);
            }
            return translated;
        }, () -> () -> LanguageHandler.translateKey(key));
    }
}

