/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.platform.fluid;

import java.util.Optional;
import mod.chiselsandbits.platforms.core.fluid.FluidInformation;
import mod.chiselsandbits.platforms.core.fluid.IFluidManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class ForgeFluidManager
implements IFluidManager {
    private static final ForgeFluidManager INSTANCE = new ForgeFluidManager();

    public static ForgeFluidManager getInstance() {
        return INSTANCE;
    }

    private ForgeFluidManager() {
    }

    @Override
    public Optional<FluidInformation> get(ItemStack stack) {
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).map(fluidStack -> new FluidInformation(fluidStack.getFluid(), fluidStack.getAmount(), fluidStack.isEmpty() ? new CompoundTag() : fluidStack.getOrCreateTag()));
    }

    @Override
    public ItemStack extractFrom(ItemStack stack, long amount) {
        stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(handler -> handler.drain((int)amount, IFluidHandler.FluidAction.EXECUTE));
        return stack;
    }

    @Override
    public ItemStack insertInto(ItemStack stack, FluidInformation fluidInformation) {
        stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(handler -> handler.fill(this.buildFluidStack(fluidInformation), IFluidHandler.FluidAction.EXECUTE));
        return stack;
    }

    @Override
    public int getFluidColor(FluidInformation fluid) {
        return fluid.fluid().getAttributes().getColor(this.buildFluidStack(fluid));
    }

    @Override
    public Component getDisplayName(Fluid fluid) {
        return fluid.getAttributes().getDisplayName(this.buildFluidStack(new FluidInformation(fluid)));
    }

    @NotNull
    private FluidStack buildFluidStack(FluidInformation fluid) {
        if (fluid.data() == null) {
            return new FluidStack(fluid.fluid(), (int)fluid.amount());
        }
        return new FluidStack(fluid.fluid(), (int)fluid.amount(), fluid.data());
    }
}

